/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageGainIndicator;

public class SmoothedAverageGainIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final AverageGainIndicator averageGains;
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public SmoothedAverageGainIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.averageGains = new AverageGainIndicator(indicator, timeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index > this.timeFrame) {
            return ((Decimal)this.getValue(index - 1)).multipliedBy(Decimal.valueOf(this.timeFrame - 1)).plus(this.calculateGain(index)).dividedBy(Decimal.valueOf(this.timeFrame));
        }
        return (Decimal)this.averageGains.getValue(index);
    }

    private Decimal calculateGain(int index) {
        Decimal gain = this.indicator.getValue(index).minus(this.indicator.getValue(index - 1));
        return gain.isPositive() ? gain : Decimal.ZERO;
    }
}

