/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.AverageLossIndicator;

public class SmoothedAverageLossIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final AverageLossIndicator averageLosses;
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public SmoothedAverageLossIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.averageLosses = new AverageLossIndicator(indicator, timeFrame);
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index > this.timeFrame) {
            return ((Decimal)this.getValue(index - 1)).multipliedBy(Decimal.valueOf(this.timeFrame - 1)).plus(this.calculateLoss(index)).dividedBy(Decimal.valueOf(this.timeFrame));
        }
        return (Decimal)this.averageLosses.getValue(index);
    }

    private Decimal calculateLoss(int index) {
        Decimal loss = this.indicator.getValue(index).minus(this.indicator.getValue(index - 1));
        return loss.isNegative() ? loss.abs() : Decimal.ZERO;
    }
}

