/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.helpers;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class TypicalPriceIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;

    public TypicalPriceIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal maxPrice = this.series.getTick(index).getMaxPrice();
        Decimal minPrice = this.series.getTick(index).getMinPrice();
        Decimal closePrice = this.series.getTick(index).getClosePrice();
        return maxPrice.plus(minPrice).plus(closePrice).dividedBy(Decimal.THREE);
    }
}

