/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.ichimoku;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.HighestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.LowestValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MaxPriceIndicator;
import eu.verdelhan.ta4j.indicators.helpers.MinPriceIndicator;

public abstract class AbstractIchimokuLineIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> periodHigh;
    private final Indicator<Decimal> periodLow;

    public AbstractIchimokuLineIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.periodHigh = new HighestValueIndicator(new MaxPriceIndicator(series), timeFrame);
        this.periodLow = new LowestValueIndicator(new MinPriceIndicator(series), timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        return this.periodHigh.getValue(index).plus(this.periodLow.getValue(index)).dividedBy(Decimal.TWO);
    }
}

