/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.ichimoku;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.ClosePriceIndicator;

public class IchimokuChikouSpanIndicator
extends CachedIndicator<Decimal> {
    private final ClosePriceIndicator closePriceIndicator;
    private final int timeDelay;

    public IchimokuChikouSpanIndicator(TimeSeries series) {
        this(series, 26);
    }

    public IchimokuChikouSpanIndicator(TimeSeries series, int timeDelay) {
        super(series);
        this.closePriceIndicator = new ClosePriceIndicator(series);
        this.timeDelay = timeDelay;
    }

    @Override
    protected Decimal calculate(int index) {
        return (Decimal)this.closePriceIndicator.getValue(Math.max(0, index - this.timeDelay));
    }
}

