/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.statistics.CovarianceIndicator;
import eu.verdelhan.ta4j.indicators.statistics.VarianceIndicator;

public class CorrelationCoefficientIndicator
extends CachedIndicator<Decimal> {
    private VarianceIndicator variance1;
    private VarianceIndicator variance2;
    private CovarianceIndicator covariance;

    public CorrelationCoefficientIndicator(Indicator<Decimal> indicator1, Indicator<Decimal> indicator2, int timeFrame) {
        super(indicator1);
        this.variance1 = new VarianceIndicator(indicator1, timeFrame);
        this.variance2 = new VarianceIndicator(indicator2, timeFrame);
        this.covariance = new CovarianceIndicator(indicator1, indicator2, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal cov = (Decimal)this.covariance.getValue(index);
        Decimal var1 = (Decimal)this.variance1.getValue(index);
        Decimal var2 = (Decimal)this.variance2.getValue(index);
        return cov.dividedBy(var1.multipliedBy(var2).sqrt());
    }
}

