/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.SMAIndicator;

public class CovarianceIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> indicator1;
    private Indicator<Decimal> indicator2;
    private int timeFrame;
    private SMAIndicator sma1;
    private SMAIndicator sma2;

    public CovarianceIndicator(Indicator<Decimal> indicator1, Indicator<Decimal> indicator2, int timeFrame) {
        super(indicator1);
        this.indicator1 = indicator1;
        this.indicator2 = indicator2;
        this.timeFrame = timeFrame;
        this.sma1 = new SMAIndicator(indicator1, timeFrame);
        this.sma2 = new SMAIndicator(indicator2, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        int numberOfObservations = index - startIndex + 1;
        Decimal covariance = Decimal.ZERO;
        Decimal average1 = (Decimal)this.sma1.getValue(index);
        Decimal average2 = (Decimal)this.sma2.getValue(index);
        for (int i = startIndex; i <= index; ++i) {
            Decimal mul = this.indicator1.getValue(i).minus(average1).multipliedBy(this.indicator2.getValue(i).minus(average2));
            covariance = covariance.plus(mul);
        }
        covariance = covariance.dividedBy(Decimal.valueOf(numberOfObservations));
        return covariance;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " timeFrame: " + this.timeFrame;
    }
}

