/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class PeriodicalGrowthRateIndicator
extends CachedIndicator<Decimal> {
    private final Indicator<Decimal> indicator;
    private final int timeFrame;

    public PeriodicalGrowthRateIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    public double getTotalReturn() {
        Decimal totalProduct = Decimal.ONE;
        int completeTimeframes = this.getTimeSeries().getTickCount() / this.timeFrame;
        for (int i = 1; i <= completeTimeframes; ++i) {
            int index = i * this.timeFrame;
            Decimal currentReturn = (Decimal)this.getValue(index);
            if (currentReturn == Decimal.NaN) continue;
            currentReturn = currentReturn.plus(Decimal.ONE);
            totalProduct = totalProduct.multipliedBy(currentReturn);
        }
        return Math.pow(totalProduct.toDouble(), 1.0 / (double)completeTimeframes);
    }

    @Override
    protected Decimal calculate(int index) {
        Decimal currentValue = this.indicator.getValue(index);
        int helpPartialTimeframe = index % this.timeFrame;
        double helpFullTimeframes = Math.floor((double)this.indicator.getTimeSeries().getTickCount() / (double)this.timeFrame);
        double helpIndexTimeframes = (double)index / (double)this.timeFrame;
        double helpPartialTimeframeHeld = (double)helpPartialTimeframe / (double)this.timeFrame;
        double partialTimeframeHeld = helpPartialTimeframeHeld == 0.0 ? 1.0 : helpPartialTimeframeHeld;
        Decimal timeframedReturn = Decimal.NaN;
        if (index >= this.timeFrame && helpIndexTimeframes < helpFullTimeframes) {
            Decimal movingValue = this.indicator.getValue(index - this.timeFrame);
            Decimal movingSimpleReturn = currentValue.minus(movingValue).dividedBy(movingValue);
            double timeframedReturn_double = Math.pow(1.0 + movingSimpleReturn.toDouble(), 1.0 / partialTimeframeHeld) - 1.0;
            timeframedReturn = Decimal.valueOf(timeframedReturn_double);
        }
        return timeframedReturn;
    }
}

