/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.statistics;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.indicators.CachedIndicator;

public class SimpleLinearRegressionIndicator
extends CachedIndicator<Decimal> {
    private Indicator<Decimal> indicator;
    private int timeFrame;
    private Decimal slope;
    private Decimal intercept;

    public SimpleLinearRegressionIndicator(Indicator<Decimal> indicator, int timeFrame) {
        super(indicator);
        this.indicator = indicator;
        this.timeFrame = timeFrame;
    }

    @Override
    protected Decimal calculate(int index) {
        int endIndex = index;
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        if (endIndex - startIndex + 1 < 2) {
            return Decimal.NaN;
        }
        this.calculateRegressionLine(startIndex, endIndex);
        return this.slope.multipliedBy(Decimal.valueOf(index)).plus(this.intercept);
    }

    private void calculateRegressionLine(int startIndex, int endIndex) {
        Decimal sumX = Decimal.ZERO;
        Decimal sumY = Decimal.ZERO;
        for (int i = startIndex; i <= endIndex; ++i) {
            sumX = sumX.plus(Decimal.valueOf(i));
            sumY = sumY.plus(this.indicator.getValue(i));
        }
        Decimal nbObservations = Decimal.valueOf(endIndex - startIndex + 1);
        Decimal xBar = sumX.dividedBy(nbObservations);
        Decimal yBar = sumY.dividedBy(nbObservations);
        Decimal xxBar = Decimal.ZERO;
        Decimal xyBar = Decimal.ZERO;
        for (int i = startIndex; i <= endIndex; ++i) {
            Decimal dX = Decimal.valueOf(i).minus(xBar);
            Decimal dY = this.indicator.getValue(i).minus(yBar);
            xxBar = xxBar.plus(dX.multipliedBy(dX));
            xyBar = xyBar.plus(dX.multipliedBy(dY));
        }
        this.slope = xyBar.dividedBy(xxBar);
        this.intercept = yBar.minus(this.slope.multipliedBy(xBar));
    }
}

