/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.CachedIndicator;
import eu.verdelhan.ta4j.indicators.helpers.CloseLocationValueIndicator;
import eu.verdelhan.ta4j.indicators.helpers.VolumeIndicator;

public class ChaikinMoneyFlowIndicator
extends CachedIndicator<Decimal> {
    private TimeSeries series;
    private CloseLocationValueIndicator clvIndicator;
    private VolumeIndicator volumeIndicator;
    private int timeFrame;

    public ChaikinMoneyFlowIndicator(TimeSeries series, int timeFrame) {
        super(series);
        this.series = series;
        this.timeFrame = timeFrame;
        this.clvIndicator = new CloseLocationValueIndicator(series);
        this.volumeIndicator = new VolumeIndicator(series, timeFrame);
    }

    @Override
    protected Decimal calculate(int index) {
        int startIndex = Math.max(0, index - this.timeFrame + 1);
        Decimal sumOfMoneyFlowVolume = Decimal.ZERO;
        for (int i = startIndex; i <= index; ++i) {
            sumOfMoneyFlowVolume = sumOfMoneyFlowVolume.plus(this.getMoneyFlowVolume(i));
        }
        Decimal sumOfVolume = (Decimal)this.volumeIndicator.getValue(index);
        return sumOfMoneyFlowVolume.dividedBy(sumOfVolume);
    }

    private Decimal getMoneyFlowVolume(int index) {
        return ((Decimal)this.clvIndicator.getValue(index)).multipliedBy(this.series.getTick(index).getVolume());
    }
}

