/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.indicators.volume;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Tick;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.indicators.RecursiveCachedIndicator;

public class NVIIndicator
extends RecursiveCachedIndicator<Decimal> {
    private final TimeSeries series;

    public NVIIndicator(TimeSeries series) {
        super(series);
        this.series = series;
    }

    @Override
    protected Decimal calculate(int index) {
        if (index == 0) {
            return Decimal.THOUSAND;
        }
        Tick currentTick = this.series.getTick(index);
        Tick previousTick = this.series.getTick(index - 1);
        Decimal previousValue = (Decimal)this.getValue(index - 1);
        if (currentTick.getVolume().isLessThan(previousTick.getVolume())) {
            Decimal currentPrice = currentTick.getClosePrice();
            Decimal previousPrice = previousTick.getClosePrice();
            Decimal priceChangeRatio = currentPrice.minus(previousPrice).dividedBy(previousPrice);
            return previousValue.plus(priceChangeRatio.multipliedBy(previousValue));
        }
        return previousValue;
    }
}

