/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.trading.rules;

import eu.verdelhan.ta4j.Order;
import eu.verdelhan.ta4j.TradingRecord;
import eu.verdelhan.ta4j.trading.rules.AbstractRule;

public class WaitForRule
extends AbstractRule {
    private Order.OrderType orderType;
    private int numberOfTicks;

    public WaitForRule(Order.OrderType orderType, int numberOfTicks) {
        this.orderType = orderType;
        this.numberOfTicks = numberOfTicks;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Order lastOrder;
        boolean satisfied = false;
        if (tradingRecord != null && (lastOrder = tradingRecord.getLastOrder(this.orderType)) != null) {
            int currentNumberOfTicks = index - lastOrder.getIndex();
            satisfied = currentNumberOfTicks >= this.numberOfTicks;
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

