/*
 * Decompiled with CFR 0.152.
 */
package eu.vitaliy.pl.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class IBMLatinCharset
extends Charset {
    private static char[][] convertChars = new char[][]{{'\u0104', '\u00a4'}, {'\u0105', '\u00a5'}, {'\u0106', '\u008f'}, {'\u0107', '\u0086'}, {'\u0118', '\u00a8'}, {'\u0119', '\u00a9'}, {'\u0141', '\u009d'}, {'\u0142', '\u0088'}, {'\u0143', '\u00e3'}, {'\u0144', '\u00e4'}, {'\u00d3', '\u00e0'}, {'\u00f3', '\u00a2'}, {'\u015a', '\u0097'}, {'\u015b', '\u0098'}, {'\u0179', '\u008d'}, {'\u017a', '\u00ab'}, {'\u017b', '\u00bd'}, {'\u017c', '\u00be'}};

    public IBMLatinCharset(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.equals(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new PrivCharsetDecoder(this, 1.0f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new PrivCharsetEncoder(this, 1.0f, 1.0f);
    }

    public class PrivCharsetDecoder
    extends CharsetDecoder {
        public PrivCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
            super(cs, averageCharsPerByte, maxCharsPerByte);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = (char)(in.get() & 0xFF);
                for (int i = 0; i < convertChars.length; ++i) {
                    if (inputChar != convertChars[i][1]) continue;
                    inputChar = convertChars[i][0];
                }
                out.put(inputChar);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    public class PrivCharsetEncoder
    extends CharsetEncoder {
        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
            super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
        }

        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
            super(cs, averageBytesPerChar, maxBytesPerChar);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = in.get();
                for (int i = 0; i < convertChars.length; ++i) {
                    if (inputChar != convertChars[i][0]) continue;
                    inputChar = convertChars[i][1];
                }
                out.put((byte)(inputChar & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

