/*
 * Decompiled with CFR 0.152.
 */
package eu.vitaliy.pl.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class MazoviaCharset
extends Charset {
    public static final char[][] CHARS_UNICODE_SORT = new char[][]{{'\u0104', '\u008f'}, {'\u0105', '\u0086'}, {'\u0106', '\u0095'}, {'\u0107', '\u008d'}, {'\u0118', '\u0090'}, {'\u0119', '\u0091'}, {'\u0141', '\u009c'}, {'\u0142', '\u0092'}, {'\u0143', '\u00a5'}, {'\u0144', '\u00a4'}, {'\u00d3', '\u00a3'}, {'\u00f3', '\u00a2'}, {'\u015a', '\u0098'}, {'\u015b', '\u009e'}, {'\u0179', '\u00a0'}, {'\u017a', '\u00a6'}, {'\u017b', '\u00a1'}, {'\u017c', '\u00a7'}};

    public MazoviaCharset(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.equals(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new PrivCharsetDecoder(this, 1.0f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new PrivCharsetEncoder(this, 1.0f, 1.0f);
    }

    public class PrivCharsetDecoder
    extends CharsetDecoder {
        public PrivCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
            super(cs, averageCharsPerByte, maxCharsPerByte);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = (char)(in.get() & 0xFF);
                for (int i = 0; i < CHARS_UNICODE_SORT.length; ++i) {
                    if (inputChar != CHARS_UNICODE_SORT[i][1]) continue;
                    inputChar = CHARS_UNICODE_SORT[i][0];
                }
                out.put(inputChar);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    public class PrivCharsetEncoder
    extends CharsetEncoder {
        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
            super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
        }

        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
            super(cs, averageBytesPerChar, maxBytesPerChar);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = in.get();
                for (int i = 0; i < CHARS_UNICODE_SORT.length; ++i) {
                    if (inputChar != CHARS_UNICODE_SORT[i][0]) continue;
                    inputChar = CHARS_UNICODE_SORT[i][1];
                }
                out.put((byte)(inputChar & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

