/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio;

import eu.xeli.jpigpio.Alert;
import eu.xeli.jpigpio.BadValueException;
import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;

public class GPIO {
    private JPigpio pigpio;
    private int pin;

    public GPIO(JPigpio jPigpio, int n) {
        assert (jPigpio != null);
        this.pigpio = jPigpio;
        this.pin = n;
    }

    public GPIO(JPigpio jPigpio, int n, int n2) throws PigpioException {
        this(jPigpio, n);
        this.setDirection(n2);
    }

    public int getDirection() throws PigpioException {
        return this.pigpio.gpioGetMode(this.pin);
    }

    public void setDirection(int n) throws PigpioException {
        this.pigpio.gpioSetMode(this.pin, n);
    }

    public void setValue(boolean bl) throws PigpioException {
        this.pigpio.gpioWrite(this.pin, bl);
    }

    public void setValue(int n) throws PigpioException {
        if (n != 0 && n != 1) {
            throw new BadValueException();
        }
        this.pigpio.gpioWrite(this.pin, n == 1);
    }

    public boolean getValue() throws PigpioException {
        return this.pigpio.gpioRead(this.pin);
    }

    public int getPin() {
        return this.pin;
    }

    public void setAlert(Alert alert) throws PigpioException {
        this.pigpio.gpioSetAlertFunc(this.getPin(), alert);
    }

    public void setPulldown(int n) throws PigpioException {
        this.pigpio.gpioSetPullUpDown(this.getPin(), n);
    }

    public void delay(long l, int n) throws PigpioException {
        this.pigpio.gpioDelay(l, n);
    }

    public JPigpio getPigpio() {
        return this.pigpio;
    }
}

