/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio;

import eu.xeli.jpigpio.Alert;
import eu.xeli.jpigpio.GPIOListener;
import eu.xeli.jpigpio.NotImplementedException;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Pulse;
import eu.xeli.jpigpio.SocketLock;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.impl.CommonPigpio;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class PigpioSocket
extends CommonPigpio {
    String host;
    int port;
    SocketLock slCmd;
    NotificationRouter router = null;
    public final int PIGPIOD_MESSAGE_SIZE = 12;
    private final int CMD_MODES = 0;
    private final int CMD_MODEG = 1;
    private final int CMD_PUD = 2;
    private final int CMD_READ = 3;
    private final int CMD_WRITE = 4;
    private final int CMD_PWM = 5;
    private final int CMD_PRS = 6;
    private final int CMD_PFS = 7;
    private final int CMD_SERVO = 8;
    private final int CMD_WDOG = 9;
    private final int CMD_BR1 = 10;
    private final int CMD_TICK = 16;
    private final int CMD_NO = 18;
    private final int CMD_NB = 19;
    private final int CMD_NP = 20;
    private final int CMD_NC = 21;
    private final int CMD_PRG = 22;
    private final int CMD_PFG = 23;
    private final int CMD_PRRG = 24;
    private final int CMD_WVCLR = 27;
    private final int CMD_WVAG = 28;
    private final int CMD_WVAS = 29;
    private final int CMD_WVBSY = 32;
    private final int CMD_WVHLT = 33;
    private final int CMD_TRIG = 37;
    private final int CMD_MILS = 47;
    private final int CMD_WVCRE = 49;
    private final int CMD_WVDEL = 50;
    private final int CMD_WVTX = 51;
    private final int CMD_WVTXR = 52;
    private final int CMD_WVNEW = 53;
    private final int CMD_I2CO = 54;
    private final int CMD_I2CC = 55;
    private final int CMD_I2CRD = 56;
    private final int CMD_I2CWD = 57;
    private final int CMD_SPIO = 71;
    private final int CMD_SPIC = 72;
    private final int CMD_SPIR = 73;
    private final int CMD_SPIW = 74;
    private final int CMD_SPIX = 75;
    private final int CMD_SERO = 76;
    private final int CMD_SERC = 77;
    private final int CMD_SERRB = 78;
    private final int CMD_SERWB = 79;
    private final int CMD_SERR = 80;
    private final int CMD_SERW = 81;
    private final int CMD_SERDA = 82;
    private final int CMD_GDC = 83;
    private final int CMD_FG = 97;
    private final int CMD_NOIB = 99;

    public PigpioSocket(String string, int n) throws PigpioException {
        this.host = string;
        this.port = n;
        this.gpioInitialize();
    }

    @Override
    public void gpioInitialize() throws PigpioException {
        try {
            if (this.slCmd == null) {
                this.slCmd = new SocketLock(this.host, this.port);
            }
            if (this.router == null) {
                this.router = new NotificationRouter(this.slCmd, this.host, this.port);
                this.router.start();
            }
        }
        catch (PigpioException | IOException exception) {
            throw new PigpioException("gpioInitialize", exception);
        }
    }

    @Override
    public void reconnect() throws PigpioException {
        try {
            this.slCmd.reconnect();
            this.router.reconnect();
        }
        catch (PigpioException | IOException exception) {
            throw new PigpioException("gpioReconnect", exception);
        }
    }

    @Override
    public void gpioTerminate() throws PigpioException {
        try {
            if (this.router != null) {
                this.router.terminate();
                this.router = null;
            }
            if (this.slCmd != null) {
                this.slCmd.terminate();
                this.slCmd = null;
            }
        }
        catch (Exception exception) {
            throw new PigpioException("gpioTerminate", exception);
        }
    }

    @Override
    public void gpioSetMode(int n, int n2) throws PigpioException {
        try {
            int n3 = this.slCmd.sendCmd(0, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioSetMode", iOException);
        }
    }

    @Override
    public int gpioGetMode(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(1, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioGetMode", iOException);
        }
    }

    @Override
    public void gpioSetPullUpDown(int n, int n2) throws PigpioException {
        try {
            int n3 = this.slCmd.sendCmd(2, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioSetPullUpDown", iOException);
        }
    }

    @Override
    public boolean gpioRead(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(3, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            return n2 != 0;
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioRead", iOException);
        }
    }

    @Override
    public void gpioWrite(int n, boolean bl) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(4, n, bl ? 1 : 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioWrite", iOException);
        }
    }

    @Override
    public int notifyOpen() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(18, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new PigpioException("notifyOpen", iOException);
        }
    }

    @Override
    public void notifyBegin(int n, int n2) throws PigpioException {
        try {
            int n3 = this.slCmd.sendCmd(19, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("notifyBegin", iOException);
        }
    }

    @Override
    public void notifyPause(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(20, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("notifyPause", iOException);
        }
    }

    @Override
    public void notifyClose(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(21, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("notifyClose", iOException);
        }
    }

    @Override
    public void setWatchdog(int n, int n2) throws PigpioException {
        try {
            int n3 = this.slCmd.sendCmd(9, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("setWatchdog", iOException);
        }
    }

    @Override
    public void waveClear() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(27, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("waveClear", iOException);
        }
    }

    @Override
    public int waveAddGeneric(ArrayList<Pulse> arrayList) throws PigpioException {
        if (arrayList == null || arrayList.size() == 0) {
            return 0;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(arrayList.size() * 12);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (Pulse pulse : arrayList) {
                byteBuffer.putInt(pulse.gpioOn).putInt(pulse.gpioOff).putInt(pulse.delay);
            }
            int n = this.slCmd.sendCmd(28, 0, 0, arrayList.size() * 12, byteBuffer.array());
            if (n < 0) {
                throw new PigpioException(n);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveAddGeneric", iOException);
        }
    }

    @Override
    public int waveAddSerial(int n, int n2, byte[] byArray, int n3, int n4, int n5) throws PigpioException {
        if (byArray.length == 0) {
            return 0;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(12);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(n4).putInt(n5).putInt(n3);
            byteBuffer.put(byArray);
            int n6 = this.slCmd.sendCmd(29, n, n2, byArray.length + 12, byteBuffer.array());
            if (n6 < 0) {
                throw new PigpioException(n6);
            }
            return n6;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveAddSerial", iOException);
        }
    }

    @Override
    public void waveAddNew() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(53, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("waveAddNew", iOException);
        }
    }

    @Override
    public boolean waveTxBusy() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(32, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
            return n != 0;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveTxBusy", iOException);
        }
    }

    @Override
    public int waveTxStop() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(33, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveTxStop", iOException);
        }
    }

    @Override
    public int waveCreate() throws PigpioException {
        try {
            int n = this.slCmd.sendCmd(49, 0, 0);
            if (n < 0) {
                throw new PigpioException(n);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveCreate", iOException);
        }
    }

    @Override
    public void waveDelete(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(50, 0, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("waveDelete", iOException);
        }
    }

    @Override
    public int waveSendOnce(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(51, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveSendOnce", iOException);
        }
    }

    @Override
    public int waveSendRepeat(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(52, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new PigpioException("waveSendRepeat", iOException);
        }
    }

    @Override
    public int i2cOpen(int n, int n2) throws PigpioException {
        try {
            return this.slCmd.sendCmd(54, n, n2);
        }
        catch (IOException iOException) {
            throw new PigpioException("i2cOpen", iOException);
        }
    }

    @Override
    public void i2cClose(int n) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(55, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("i2cClose", iOException);
        }
    }

    @Override
    public int i2cReadDevice(int n, byte[] byArray) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(56, n, byArray.length);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            this.slCmd.readBytes(byArray);
            return n2;
        }
        catch (IOException iOException) {
            throw new PigpioException("i2cReadDevice", iOException);
        }
    }

    @Override
    public void i2cWriteDevice(int n, byte[] byArray) throws PigpioException {
        try {
            int n2 = this.slCmd.sendCmd(57, n, 0, byArray.length, byArray);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("i2cWriteDevice");
        }
    }

    @Override
    public void gpioDelay(long l) throws PigpioException {
        try {
            this.slCmd.sendCmd(47, (int)l, 0);
            return;
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioDelay", iOException);
        }
    }

    @Override
    public long gpioTick() throws PigpioException {
        try {
            return Integer.toUnsignedLong(this.slCmd.sendCmd(16, 0, 0));
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioTick", iOException);
        }
    }

    @Override
    public long getCurrentTick() throws PigpioException {
        return this.gpioTick();
    }

    @Override
    public void gpioServo(int n, int n2) throws PigpioException {
        try {
            int n3 = this.slCmd.sendCmd(8, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioServo", iOException);
        }
    }

    @Override
    public void setServoPulseWidth(int n, int n2) throws PigpioException {
        this.gpioServo(n, n2);
    }

    @Override
    public int getServoPulseWidth(int n) throws PigpioException {
        throw new NotImplementedException();
    }

    @Override
    public void gpioSetAlertFunc(int n, final Alert alert) throws PigpioException {
        this.router.addListener(new GPIOListener(n, 2){

            @Override
            public void alert(int n, int n2, long l) {
                alert.alert(n, n2, l);
            }
        });
    }

    @Override
    public void gpioTrigger(int n, long l, boolean bl) throws PigpioException {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(bl ? 1 : 0);
            int n2 = this.slCmd.sendCmd(37, n, (int)l, 4, byteBuffer.array());
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioTrigger");
        }
    }

    @Override
    public int spiOpen(int n, int n2, int n3) throws PigpioException {
        int n4 = 0;
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(n3);
            n4 = this.slCmd.sendCmd(71, n, n2, 4, byteBuffer.array());
            if (n4 < 0) {
                throw new PigpioException(n4);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("spiOpen failed", iOException);
        }
        return n4;
    }

    @Override
    public void spiClose(int n) throws PigpioException {
        try {
            this.slCmd.sendCmd(72, n, 0);
        }
        catch (IOException iOException) {
            throw new PigpioException("spiClose failed", iOException);
        }
    }

    @Override
    public int spiRead(int n, byte[] byArray) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(73, n, byArray.length);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
            if (n2 > 0) {
                this.slCmd.readBytes(byArray);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new PigpioException("spiRead failed", iOException);
        }
    }

    @Override
    public int spiWrite(int n, byte[] byArray) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(74, n, 0, byArray.length, byArray);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("spiWrite failed", iOException);
        }
        return n2;
    }

    @Override
    public int spiXfer(int n, byte[] byArray, byte[] byArray2) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(75, n, 0, byArray.length, byArray);
            if (n2 > 0) {
                this.slCmd.readBytes(byArray2);
            } else if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("spiXfer failed", iOException);
        }
        return n2;
    }

    @Override
    public void setPWMDutycycle(int n, int n2) throws PigpioException {
        try {
            this.slCmd.sendCmd(5, n, n2);
        }
        catch (IOException iOException) {
            throw new PigpioException("setPWMDutycycle failed", iOException);
        }
    }

    @Override
    public int getPWMDutycycle(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(83, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("getPWMDutycycle failed", iOException);
        }
        return n2;
    }

    @Override
    public void setPWMRange(int n, int n2) throws PigpioException {
        try {
            this.slCmd.sendCmd(6, n, n2);
        }
        catch (IOException iOException) {
            throw new PigpioException("setPWMRange failed", iOException);
        }
    }

    @Override
    public int getPWMRange(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(22, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("getPWMRange failed", iOException);
        }
        return n2;
    }

    @Override
    public int getPWMRealRange(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(24, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("getPWMRealRange failed", iOException);
        }
        return n2;
    }

    @Override
    public int setPWMFrequency(int n, int n2) throws PigpioException {
        int n3 = 0;
        try {
            n3 = this.slCmd.sendCmd(7, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("setPWMFrequency failed", iOException);
        }
        return n3;
    }

    @Override
    public int getPWMFrequency(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(23, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("getPWMFrequency failed", iOException);
        }
        return n2;
    }

    @Override
    public int serialOpen(String string, int n, int n2) throws PigpioException {
        int n3 = 0;
        try {
            n3 = this.slCmd.sendCmd(76, n, n2, string.length(), string.getBytes());
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("serialOpen failed", iOException);
        }
        return n3;
    }

    @Override
    public void serialClose(int n) throws PigpioException {
        try {
            this.slCmd.sendCmd(77, n, 0);
        }
        catch (IOException iOException) {
            throw new PigpioException("serialClose failed", iOException);
        }
    }

    @Override
    public byte serialReadByte(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(78, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("serialReadByte failed", iOException);
        }
        return (byte)n2;
    }

    @Override
    public void serialWriteByte(int n, byte by) throws PigpioException {
        try {
            this.slCmd.sendCmd(79, n, by);
        }
        catch (IOException iOException) {
            throw new PigpioException("serialWriteByte failed", iOException);
        }
    }

    @Override
    public byte[] serialRead(int n, int n2) throws PigpioException {
        byte[] byArray = new byte[1];
        int n3 = 0;
        try {
            n3 = this.slCmd.sendCmd(80, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
            if (n3 > 0) {
                byArray = new byte[n3];
                this.slCmd.readBytes(byArray);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("serialRead failed", iOException);
        }
        return byArray;
    }

    @Override
    public void serialWrite(int n, byte[] byArray) throws PigpioException {
        try {
            this.slCmd.sendCmd(81, n, 0, byArray.length, byArray);
        }
        catch (IOException iOException) {
            throw new PigpioException("serialWrite failed", iOException);
        }
    }

    @Override
    public int serialDataAvailable(int n) throws PigpioException {
        int n2 = 0;
        try {
            n2 = this.slCmd.sendCmd(82, n, 0);
            if (n2 < 0) {
                throw new PigpioException(n2);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("serialDataAvailable failed", iOException);
        }
        return n2;
    }

    @Override
    public void setDebug(boolean bl) throws PigpioException {
        throw new NotImplementedException();
    }

    @Override
    public long gpioxPulseAndWait(int n, int n2, long l, long l2, boolean bl) throws PigpioException {
        throw new NotImplementedException();
    }

    @Override
    public void addCallback(GPIOListener gPIOListener) throws PigpioException {
        this.router.addListener(gPIOListener);
    }

    @Override
    public void removeCallback(GPIOListener gPIOListener) throws PigpioException {
        this.router.removeListener(gPIOListener);
    }

    @Override
    public void gpioGlitchFilter(int n, int n2) throws PigpioException {
        int n3 = 0;
        try {
            n3 = this.slCmd.sendCmd(97, n, n2);
            if (n3 < 0) {
                throw new PigpioException(n3);
            }
        }
        catch (IOException iOException) {
            throw new PigpioException("gpioGlitchFilter failed", iOException);
        }
    }

    class NotificationRouter
    implements Runnable {
        SocketLock slNotify;
        SocketLock slPiCmd;
        int handle;
        boolean go = true;
        Thread thread;
        ArrayList<GPIOListener> gpioListeners = new ArrayList();
        int monitor = 0;
        String host;
        int port;

        public NotificationRouter(SocketLock socketLock, String string, int n) throws PigpioException {
            this.slPiCmd = socketLock;
            this.host = string;
            this.port = n;
            this.reconnect();
        }

        public void reconnect() throws PigpioException {
            try {
                if (this.slNotify != null) {
                    this.slNotify.reconnect();
                } else {
                    this.slNotify = new SocketLock(this.host, this.port);
                }
                this.handle = this.slNotify.sendCmd(99, 0, 0);
            }
            catch (IOException iOException) {
                throw new PigpioException("NotificationRouter", iOException);
            }
        }

        public void terminate() throws PigpioException {
            if (this.go) {
                this.go = false;
                try {
                    this.slPiCmd.sendCmd(21, this.handle, 0);
                    this.slNotify.terminate();
                }
                catch (IOException iOException) {
                    throw new PigpioException("NotificationRouter.terminate", iOException);
                }
            }
        }

        public void addListener(GPIOListener gPIOListener) throws PigpioException {
            try {
                this.gpioListeners.add(gPIOListener);
                this.monitor |= gPIOListener.bit;
                this.slPiCmd.sendCmd(19, this.handle, this.monitor);
            }
            catch (IOException iOException) {
                throw new PigpioException("NotificationRouter.addListener", iOException);
            }
        }

        public void removeListener(GPIOListener gPIOListener) throws PigpioException {
            int n = 0;
            if (this.gpioListeners.remove(gPIOListener)) {
                for (GPIOListener gPIOListener2 : this.gpioListeners) {
                    n |= gPIOListener2.bit;
                }
                if (n != this.monitor) {
                    this.monitor = n;
                    try {
                        this.slPiCmd.sendCmd(19, this.handle, this.monitor);
                    }
                    catch (IOException iOException) {
                        throw new PigpioException("NotificationRouter.removeListener", iOException);
                    }
                }
            }
        }

        @Override
        public void run() {
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[4];
            try {
                int n3 = this.slPiCmd.sendCmd(10, 0, 0);
                while (this.go) {
                    while (this.go && this.slNotify.in.available() < 12) {
                        Thread.sleep(20L);
                    }
                    if (!this.go) break;
                    int n4 = Integer.reverseBytes(this.slNotify.in.readUnsignedShort());
                    int n5 = Integer.reverseBytes(this.slNotify.in.readUnsignedShort());
                    this.slNotify.in.read(byArray, 0, 4);
                    long l = Utils.LEint2Long(byArray);
                    int n6 = Integer.reverseBytes(this.slNotify.in.readInt());
                    if (n5 == 0) {
                        int n7 = n6 ^ n3;
                        n3 = n6;
                        for (GPIOListener gPIOListener : this.gpioListeners) {
                            if ((gPIOListener.bit & n7) == 0) continue;
                            n = 0;
                            if ((gPIOListener.bit & n6) != 0) {
                                n = 1;
                            }
                            if ((gPIOListener.edge ^ n) == 0) continue;
                            gPIOListener.alert(gPIOListener.gpio, n, l);
                        }
                        continue;
                    }
                    if ((n5 & 0x20) == 0) continue;
                    n2 = n5 & 0x20;
                    for (GPIOListener gPIOListener : this.gpioListeners) {
                        if (gPIOListener.gpio != n2) continue;
                        gPIOListener.alert(gPIOListener.gpio, 2, l);
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }
}

