/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;

public class SocketLock {
    String host;
    int port;
    Socket socket;
    DataInputStream in;
    DataOutputStream out;
    int replyTimeout = 10000;

    public SocketLock(String string, int n) throws IOException {
        this.host = string;
        this.port = n;
        this.reconnect();
    }

    public void reconnect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
    }

    public void terminate() throws IOException {
        this.in.close();
        this.in = null;
        this.out.flush();
        this.out.close();
        this.out = null;
        this.socket.close();
        this.socket = null;
    }

    public synchronized int sendCmd(int n, int n2, int n3) throws IOException {
        byte[] byArray = new byte[]{};
        return this.sendCmd(n, n2, n3, 0, byArray);
    }

    public synchronized int sendCmd(int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16 + byArray.length);
        byteBuffer.putInt(Integer.reverseBytes(n));
        byteBuffer.putInt(Integer.reverseBytes(n2));
        byteBuffer.putInt(Integer.reverseBytes(n3));
        byteBuffer.putInt(Integer.reverseBytes(n4));
        if (byArray.length > 0) {
            byteBuffer.put(byArray);
        }
        this.out.write(byteBuffer.array());
        this.out.flush();
        int n5 = this.replyTimeout;
        int n6 = this.in.available();
        while (n5 > 0 && n6 < 16) {
            n5 -= 10;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n6 = this.in.available();
        }
        if (this.in.available() < 16) {
            throw new IOException("Timeout: No response from RPi withing " + this.replyTimeout + " ms.");
        }
        int n7 = Integer.reverseBytes(this.in.readInt());
        n7 = Integer.reverseBytes(this.in.readInt());
        n7 = Integer.reverseBytes(this.in.readInt());
        n7 = Integer.reverseBytes(this.in.readInt());
        return n7;
    }

    public void readBytes(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }
}

