/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio;

import eu.xeli.jpigpio.JPigpio;
import java.nio.ByteBuffer;

public class Utils {
    public static void addShutdown(JPigpio jPigpio) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                jPigpio.gpioTerminate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }));
    }

    public static int mapToInt(int n, int n2, int n3, int n4, int n5) {
        double d = (double)(n - n2) / (double)(n3 - n2);
        return (int)((double)n4 + (double)(n5 - n4) * d);
    }

    public static String byteToBinary(byte by) {
        return String.format("%8s", Integer.toBinaryString(by & 0xFF)).replace(' ', '0');
    }

    public static String int16ToBinary(int n) {
        if (Integer.toUnsignedLong(n) != Integer.toUnsignedLong(n & 0xFFFF)) {
            System.out.println(String.format("Warning: value is: 0x%x while masked value is 0x%x", Integer.toUnsignedLong(n), n & 0xFFFF));
        }
        return Utils.splitBinary4(String.format("%16s", Integer.toBinaryString(n & 0xFFFF)).replace(' ', '0'));
    }

    public static int byteWordToInt(byte[] byArray) {
        return (int)(Byte.toUnsignedLong(byArray[0]) << 8 | Byte.toUnsignedLong(byArray[1]));
    }

    private static String splitBinary4(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); i += 4) {
            if (i > 0) {
                string2 = string2 + " ";
            }
            string2 = i < string.length() ? string2 + string.substring(i, i + 4) : string2 + string.substring(i);
        }
        return string2;
    }

    public static int setBit(int n, int n2) {
        assert (n2 >= 0 && n2 < 16);
        return n | Utils.bitMask(n2);
    }

    public static byte setBit(byte by, int n) {
        assert (n >= 0 && n < 16);
        return (byte)(by | Utils.bitMask(n));
    }

    public static int clearBit(int n, int n2) {
        assert (n2 >= 0 && n2 < 16);
        return n & ~Utils.bitMask(n2);
    }

    public static byte clearBit(byte by, int n) {
        assert (n >= 0 && n < 16);
        return (byte)(by & ~Utils.bitMask(n));
    }

    public static int bitMask(int n) {
        assert (n >= 0 && n < 16);
        return 1 << n;
    }

    public static boolean isSet(int n, int n2) {
        assert (n2 >= 0 && n2 < 16);
        return (n & Utils.bitMask(n2)) != 0;
    }

    public static boolean isSet(byte by, int n) {
        assert (n >= 0 && n < 16);
        return (by & Utils.bitMask(n)) != 0;
    }

    public static String dumpData(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + String.format("%2x", byArray[i]).replace(' ', '0') + " ";
        }
        return string;
    }

    public static String bitString(boolean bl) {
        return bl ? "1" : "0";
    }

    public static long tickDiff(long l, long l2) {
        int n = (int)(l2 - l);
        return Integer.toUnsignedLong(n);
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        char[] cArray2 = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray2[i * 2] = cArray[n >>> 4];
            cArray2[i * 2 + 1] = cArray[n & 0xF];
        }
        return new String(cArray2);
    }

    public static byte[] bytes2nibbles(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i * 2] = (byte)(byArray[i] >> 4);
            byArray2[i * 2 + 1] = (byte)(byArray[i] & 0xF);
        }
        return byArray2;
    }

    public static byte[] nibbles2bytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(byArray[i * 2] << 4 | byArray[i * 2 + 1]);
        }
        return byArray2;
    }

    public static Long LEint2Long(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 4; ++i) {
            byArray2[7 - i] = byArray[i];
        }
        Long l = ByteBuffer.wrap(byArray2).getLong();
        return l;
    }
}

