/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.NotImplementedException;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.WrongModeException;

public class LCD {
    private JPigpio pigpio;
    private int registerSelectGpio;
    private int readWriteGpio;
    private int enableGpio;
    private int db4Gpio;
    private int db5Gpio;
    private int db6Gpio;
    private int db7Gpio;
    private byte displayMode;
    private byte functionMode;
    private byte entryMode;
    private final boolean RW_READ = true;
    private final boolean RW_WRITE = false;
    private final boolean RS_DATA = true;
    private final boolean RS_INSTRUCTION = false;
    private final byte LCD_CLEARDISPLAY = 1;
    private final byte LCD_RETURNHOME = (byte)2;
    private final byte LCD_ENTRYMODESET = (byte)4;
    private final byte LCD_DISPLAYCONTROL = (byte)8;
    private final byte LCD_CURSORSHIFT = (byte)16;
    private final byte LCD_FUNCTIONSET = (byte)32;
    private final byte LCD_SETCGRAMADDR = (byte)64;
    private final byte LCD_SETDDRAMADDR = (byte)-128;
    private final byte LCD_ENTRYRIGHT = 0;
    private final byte LCD_ENTRYLEFT = (byte)2;
    private final byte LCD_ENTRYSHIFTINCREMENT = 1;
    private final byte LCD_ENTRYSHIFTDECREMENT = 0;
    private final byte LCD_DISPLAYON = (byte)4;
    private final byte LCD_DISPLAYOFF = 0;
    private final byte LCD_CURSORON = (byte)2;
    private final byte LCD_CURSOROFF = 0;
    private final byte LCD_BLINKON = 1;
    private final byte LCD_BLINKOFF = 0;
    private final byte LCD_DISPLAYMOVE = (byte)8;
    private final byte LCD_CURSORMOVE = 0;
    private final byte LCD_MOVERIGHT = (byte)4;
    private final byte LCD_MOVELEFT = 0;
    private final byte LCD_8BITMODE = (byte)16;
    private final byte LCD_4BITMODE = 0;
    private final byte LCD_2LINE = (byte)8;
    private final byte LCD_1LINE = 0;
    private final byte LCD_5x10DOTS = (byte)4;
    private final byte LCD_5x8DOTS = 0;

    public LCD(JPigpio jPigpio, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws PigpioException {
        this.pigpio = jPigpio;
        this.registerSelectGpio = n;
        this.readWriteGpio = n2;
        this.enableGpio = n3;
        this.db4Gpio = n4;
        this.db5Gpio = n5;
        this.db6Gpio = n6;
        this.db7Gpio = n7;
        if (jPigpio.gpioGetMode(this.registerSelectGpio) != 1) {
            throw new WrongModeException(this.registerSelectGpio);
        }
        if (jPigpio.gpioGetMode(this.readWriteGpio) != 1) {
            throw new WrongModeException(this.readWriteGpio);
        }
        if (jPigpio.gpioGetMode(this.enableGpio) != 1) {
            throw new WrongModeException(this.enableGpio);
        }
        if (jPigpio.gpioGetMode(this.db4Gpio) != 1) {
            throw new WrongModeException(this.db4Gpio);
        }
        if (jPigpio.gpioGetMode(this.db5Gpio) != 1) {
            throw new WrongModeException(this.db5Gpio);
        }
        if (jPigpio.gpioGetMode(this.db6Gpio) != 1) {
            throw new WrongModeException(this.db6Gpio);
        }
        if (jPigpio.gpioGetMode(this.db7Gpio) != 1) {
            throw new WrongModeException(this.db7Gpio);
        }
        this.displayMode = (byte)12;
        this.functionMode = (byte)36;
        this.entryMode = (byte)6;
        System.out.println(String.format("registerSelect: %d\nreadWrite: %d\nenable: %d\ndb4=%d\ndb5=%d\ndb6=%d\ndb7=%d", n, n2, n3, n4, n5, n6, n7));
        jPigpio.gpioWrite(this.enableGpio, false);
        this.init();
    }

    private void init() throws PigpioException {
        System.out.println("init >");
        this.pigpio.gpioDelay(50000L);
        this.write4bits(false, false, (byte)3);
        this.pulseEnable();
        this.pigpio.gpioDelay(4500L);
        this.write4bits(false, false, (byte)3);
        this.pulseEnable();
        this.pigpio.gpioDelay(4500L);
        this.write4bits(false, false, (byte)3);
        this.pulseEnable();
        this.pigpio.gpioDelay(4500L);
        this.write4bits(false, false, (byte)2);
        this.pulseEnable();
        this.functionModeSet();
        this.displayModeSet();
        this.entryModeSet();
    }

    public void clear() throws PigpioException {
        System.out.println("clear>");
        this.write(false, false, (byte)1);
    }

    public void home() throws PigpioException {
        System.out.println("home >");
        this.write(false, false, (byte)2);
    }

    private void displayModeSet() throws PigpioException {
        System.out.println("Display Mode >");
        this.write(false, false, this.displayMode);
    }

    public void functionModeSet() throws PigpioException {
        System.out.println("Function Mode >");
        this.write(false, false, this.functionMode);
    }

    private void setDDRAMAddress(int n) throws PigpioException {
        System.out.println("Set DDRAM Address>");
        this.write(false, false, (byte)(0x40 | n & 0x7F));
    }

    private void entryModeSet() throws PigpioException {
        System.out.println("Set setEntryMode>");
        this.write(false, false, this.entryMode);
    }

    private void writeRAM(byte by) throws PigpioException {
        System.out.println("Write RAM>");
        this.write(true, false, by);
    }

    private void write4bits(boolean bl, boolean bl2, byte by) throws PigpioException {
        this.pigpio.gpioWrite(this.registerSelectGpio, bl);
        this.pigpio.gpioWrite(this.readWriteGpio, bl2);
        this.pigpio.gpioWrite(this.db7Gpio, Utils.isSet(by, 3));
        this.pigpio.gpioWrite(this.db6Gpio, Utils.isSet(by, 2));
        this.pigpio.gpioWrite(this.db5Gpio, Utils.isSet(by, 1));
        this.pigpio.gpioWrite(this.db4Gpio, Utils.isSet(by, 0));
        System.out.println("+----+----+----+----+----+----+");
        System.out.println(String.format("|  %s |  %s |  %s |  %s |  %s |  %s |", Utils.bitString(bl), Utils.bitString(bl2), Utils.bitString(Utils.isSet(by, 3)), Utils.bitString(Utils.isSet(by, 2)), Utils.bitString(Utils.isSet(by, 1)), Utils.bitString(Utils.isSet(by, 0))));
    }

    private void write8bits(boolean bl, boolean bl2, byte by) throws PigpioException {
        throw new NotImplementedException();
    }

    private void write(boolean bl, boolean bl2, byte by) throws PigpioException {
        System.out.println("Write >");
        if (!this.is8BitMode()) {
            this.write4bits(bl, bl2, (byte)(by >>> 4));
            this.pulseEnable();
            this.write4bits(bl, bl2, (byte)(by & 0xF));
            this.pulseEnable();
        } else {
            this.write8bits(bl, bl2, by);
            this.pulseEnable();
        }
    }

    public void write(String string) throws PigpioException {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            this.writeRAM(byArray[i]);
        }
    }

    private void pulseEnable() throws PigpioException {
        this.pigpio.gpioWrite(this.enableGpio, false);
        this.pigpio.gpioDelay(100L);
        this.pigpio.gpioWrite(this.enableGpio, true);
        this.pigpio.gpioDelay(100L);
        this.pigpio.gpioWrite(this.enableGpio, false);
        this.pigpio.gpioDelay(100L);
    }

    private boolean is8BitMode() {
        return (this.functionMode & 0x10) != 0;
    }

    public void setDisplay(boolean bl) throws PigpioException {
        this.displayMode = bl ? (byte)(this.displayMode | 4) : (byte)(this.displayMode & 0xFFFFFFFB);
        this.displayModeSet();
    }

    public void setCursor(boolean bl) throws PigpioException {
        this.displayMode = bl ? (byte)(this.displayMode | 2) : (byte)(this.displayMode & 0xFFFFFFFD);
        this.displayModeSet();
    }

    public void setBlink(boolean bl) throws PigpioException {
        this.displayMode = bl ? (byte)(this.displayMode | 1) : (byte)(this.displayMode & 0xFFFFFFFE);
        this.displayModeSet();
    }

    public void setLines(int n) throws PigpioException {
        assert (n == 1 || n == 2);
        this.functionMode = n == 2 ? (byte)(this.functionMode | 8) : (byte)(this.functionMode & 0xFFFFFFF7);
        this.functionModeSet();
    }

    public void setFontHeight(int n) throws PigpioException {
        assert (n == 8 || n == 10);
        this.functionMode = n == 10 ? (byte)(this.functionMode | 4) : (byte)(this.functionMode & 0xFFFFFFFB);
        this.functionModeSet();
    }
}

