/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.WrongModeException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class NRF24L01 {
    private JPigpio pigpio;
    private int cePin;
    private int csnPin;
    private byte channel;
    private int handle;
    private boolean transmitMode;
    private int baseConfig;
    private boolean dynPayloadEnabled = false;
    private int payloadSize = 32;
    private final int MAX_PAYLOAD_SIZE = 32;
    public static final int CONFIG_REGISTER = 0;
    public static final int EN_AA = 1;
    public static final int EN_RXADDR_REGISTER = 2;
    public static final int SETUP_AW_REGISTER = 3;
    public static final int SETUP_RETR_REGISTER = 4;
    public static final int RF_CH_REGISTER = 5;
    public static final int RF_SETUP = 6;
    public static final int STATUS_REGISTER = 7;
    public static final int OBSERVE_TX = 8;
    public static final int RPD = 9;
    public static final int CD = 9;
    public static final int RX_ADDR_P0 = 10;
    public static final int RX_ADDR_P1 = 11;
    public static final int RX_ADDR_P2 = 12;
    public static final int RX_ADDR_P3 = 13;
    public static final int RX_ADDR_P4 = 14;
    public static final int RX_ADDR_P5 = 15;
    public static final int TX_ADDR = 16;
    public static final int RX_PW_P0 = 17;
    public static final int RX_PW_P1 = 18;
    public static final int RX_PW_P2 = 19;
    public static final int RX_PW_P3 = 20;
    public static final int RX_PW_P4 = 21;
    public static final int RX_PW_P5 = 22;
    public static final int FIFO_STATUS_REGISTER = 23;
    public static final int DYNPD = 28;
    public static final int FEATURE = 29;
    public static final int MASK_RX_DR = 6;
    public static final int MASK_TX_DS = 5;
    public static final int MASK_MAX_RT = 4;
    public static final int EN_CRC = 3;
    public static final int CRCO = 2;
    public static final int PWR_UP = 1;
    public static final int PRIM_RX = 0;
    public static final int ENAA_P5 = 5;
    public static final int ENAA_P4 = 4;
    public static final int ENAA_P3 = 3;
    public static final int ENAA_P2 = 2;
    public static final int ENAA_P1 = 1;
    public static final int ENAA_P0 = 0;
    public static final int ERX_P5 = 5;
    public static final int ERX_P4 = 4;
    public static final int ERX_P3 = 3;
    public static final int ERX_P2 = 2;
    public static final int ERX_P1 = 1;
    public static final int ERX_P0 = 0;
    public static final int AW = 0;
    public static final int ARD = 4;
    public static final int ARC = 0;
    private static final int CONT_WAVE = 7;
    private static final int RF_DR_LOW = 5;
    private static final int PLL_LOCK = 4;
    private static final int RF_DR_HIGH = 3;
    private static final int RF_PWR = 1;
    private static final int LNA_HCURR = 0;
    public static final int RX_DR = 6;
    public static final int TX_DS = 5;
    public static final int MAX_RT = 4;
    public static final int RX_P_NO = 1;
    public static final int TX_FULL = 5;
    public static final int PLOS_CNT = 4;
    public static final int ARC_CNT = 0;
    public static final int TX_REUSE = 6;
    public static final int FIFO_FULL = 5;
    public static final int TX_EMPTY = 4;
    public static final int RX_FULL = 1;
    public static final int RX_EMPTY = 0;
    public static final int DPL_P5 = 5;
    public static final int DPL_P4 = 4;
    public static final int DPL_P3 = 3;
    public static final int DPL_P2 = 2;
    public static final int DPL_P1 = 1;
    public static final int DPL_P0 = 0;
    public static final int EN_DPL = 2;
    public static final int EN_ACK_PAY = 1;
    public static final int EN_DYN_ACK = 0;
    private final int R_REGISTER = 0;
    private final int W_REGISTER = 32;
    private final int REGISTER_MASK = 31;
    private final int ACTIVATE = 80;
    private final int R_RX_PL_WID = 96;
    private final int R_RX_PAYLOAD = 97;
    private final int W_TX_PAYLOAD = 160;
    private final int FLUSH_TX = 225;
    private final int FLUSH_RX = 226;
    private final int REUSE_TX_PL = 227;
    private final byte NOP = (byte)-1;
    public static final int RF24_250KBPS = 2;
    public static final int RF24_1MBPS = 0;
    public static final int RF24_2MBPS = 1;
    public static final int RF24_PA_MIN = 0;
    public static final int RF24_PA_LOW = 2;
    public static final int RF24_PA_HIGH = 4;
    public static final int RF24_PA_MAX = 6;
    public static final int RF24_PA_MASK = 6;
    public static final int RF24_AW_3BYTES = 1;
    public static final int RF24_AW_4BYTES = 2;
    public static final int RF24_AW_5BYTES = 3;

    public NRF24L01(JPigpio jPigpio) {
        this.pigpio = jPigpio;
    }

    public boolean init(int n, int n2) throws PigpioException {
        this.cePin = n;
        this.csnPin = n2;
        this.pigpio.gpioSetMode(n, 1);
        this.pigpio.gpioSetMode(n2, 1);
        if (this.pigpio.gpioGetMode(n) != 1) {
            throw new WrongModeException(n);
        }
        if (this.pigpio.gpioGetMode(n2) != 1) {
            throw new WrongModeException(n2);
        }
        this.ceLow();
        this.csnHigh();
        this.handle = this.pigpio.spiOpen(0, 500000, 0);
        byte by = this.readByteRegister(6);
        if (by == 0 || by == -1) {
            return false;
        }
        this.dynPayloadEnabled = (this.readByteRegister(29) & 4) == 4;
        this.channel = this.getChannel();
        this.powerUpRx();
        this.flushRx();
        return true;
    }

    public void reset() throws PigpioException {
        this.csnLow();
        this.flushTx();
        this.csnHigh();
        this.csnLow();
        this.flushRx();
        this.csnHigh();
        this.baseConfig = 8;
        byte[] byArray = new byte[]{(byte)this.baseConfig, 63, 3, 3, 3, 2, 14, 112};
        this.writeByteRegister(0, byArray[0]);
        this.writeByteRegister(1, byArray[1]);
        this.writeByteRegister(2, byArray[2]);
        this.writeByteRegister(3, byArray[3]);
        this.writeByteRegister(4, byArray[4]);
        this.writeByteRegister(5, byArray[5]);
        this.writeByteRegister(6, byArray[6]);
        this.writeByteRegister(7, byArray[7]);
        byte[] byArray2 = new byte[]{32, 32, 32, 32, 32, 32};
        this.writeByteRegister(17, byArray2[0]);
        this.writeByteRegister(18, byArray2[1]);
        this.writeByteRegister(19, byArray2[2]);
        this.writeByteRegister(20, byArray2[3]);
        this.writeByteRegister(21, byArray2[4]);
        this.writeByteRegister(22, byArray2[5]);
        this.writeByteRegister(28, (byte)0);
        this.writeByteRegister(29, (byte)0);
        this.transmitMode = false;
        this.powerDown();
    }

    public void terminate() throws PigpioException {
        this.ceLow();
        this.powerDown();
    }

    public void config(int n) throws PigpioException {
        this.writeByteRegister(17, (byte)n);
        this.writeByteRegister(18, (byte)n);
        this.payloadSize = n;
        this.powerUpRx();
        this.flushRx();
    }

    public void setRADDR(byte[] byArray) throws PigpioException {
        this.ceLow();
        this.writeRegister(11, byArray);
        this.ceHigh();
    }

    public void setTADDR(byte[] byArray, boolean bl) throws PigpioException {
        this.writeRegister(16, byArray);
        if (bl) {
            this.writeRegister(10, byArray);
        }
    }

    public void setChannel(int n) throws PigpioException {
        this.writeByteRegister(5, (byte)(n & 0x7F));
        this.channel = (byte)n;
    }

    public void setDataRate(int n) throws PigpioException {
        byte by;
        byte by2 = by = this.readByteRegister(6);
        by2 = (n & 2) == 2 ? (byte)(by2 | 0x20) : (byte)(by2 & 0xFFFFFFDF);
        by2 = (n & 1) == 1 ? (byte)(by2 | 8) : (byte)(by2 & 0xFFFFFFF7);
        this.writeByteRegister(6, by2);
    }

    public void setPALevel(int n) throws PigpioException {
        byte by;
        byte by2 = by = this.readByteRegister(6);
        by2 = (byte)(by2 & 0xFFFFFFF9);
        by2 = (byte)(by2 | n);
        this.writeByteRegister(6, by2);
    }

    public void setAutoACK(boolean bl) throws PigpioException {
        if (bl) {
            this.writeByteRegister(1, (byte)63);
        } else {
            this.writeByteRegister(1, (byte)0);
        }
    }

    public void setAutoACK(int n, boolean bl) throws PigpioException {
        if (bl) {
            this.setRegisterBits(1, (byte)(1 << n));
        } else {
            this.clearRegisterBits(1, (byte)(1 << n));
        }
    }

    public void setPayloadSize(int n) throws PigpioException {
        this.payloadSize = n > 0 && n < 33 ? n : 32;
    }

    public void setPayloadSize(int n, int n2) throws PigpioException {
        if (n2 > 0 && n2 < 33 && n >= 0 && n < 6) {
            this.writeByteRegister(17 + n, (byte)n2);
            if (n == 0) {
                this.payloadSize = n2;
            }
        }
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    public void disableCRC() throws PigpioException {
        this.setCRCSize(0);
    }

    public void setCRCSize(int n) throws PigpioException {
        switch (n) {
            case 0: {
                this.clearRegisterBits(0, (byte)8);
                this.baseConfig &= 0xFFFFFFF7;
                break;
            }
            case 1: {
                this.setRegisterBits(0, (byte)8);
                this.baseConfig |= 8;
                this.clearRegisterBits(0, (byte)4);
                this.baseConfig &= 0xFFFFFFFB;
                break;
            }
            case 2: {
                this.setRegisterBits(0, (byte)8);
                this.baseConfig |= 8;
                this.setRegisterBits(0, (byte)4);
                this.baseConfig |= 4;
            }
        }
    }

    public void setRegisterBits(int n, byte by) throws PigpioException {
        byte by2;
        byte by3 = by2 = this.readByteRegister(n);
        by3 = (byte)(by3 | by);
        this.writeByteRegister(n, by3);
    }

    public void clearRegisterBits(int n, byte by) throws PigpioException {
        byte by2;
        byte by3 = by2 = this.readByteRegister(n);
        by3 = (byte)(by3 & ~by);
        this.writeByteRegister(n, by3);
    }

    public void setRetries(int n, int n2) throws PigpioException {
        this.writeByteRegister(4, (byte)((n & 0xF) << 4 | (n2 & 0xF) << 0));
    }

    public boolean dataReady() throws PigpioException {
        byte by = this.getStatus();
        if ((by & this.BV(6)) != 0) {
            return true;
        }
        return !this.rxFifoEmpty();
    }

    public boolean rxFifoEmpty() throws PigpioException {
        byte by = this.readByteRegister(23);
        return (by & this.BV(0)) != 0;
    }

    public boolean getData(byte[] byArray) throws PigpioException {
        this.nrfSpiWrite(97, byArray);
        this.setRegisterBits(7, (byte)64);
        return (this.readByteRegister(23) & this.BV(0)) > 0;
    }

    public void configRegister(int n, byte by) throws PigpioException {
        this.writeByteRegister(n, by);
    }

    public byte readByteRegister(int n) throws PigpioException {
        byte[] byArray = new byte[]{-1};
        this.readRegister(n, byArray);
        return byArray[0];
    }

    public void readRegister(int n, byte[] byArray) throws PigpioException {
        this.nrfSpiWrite(0 | 0x1F & n, byArray);
    }

    public void writeRegister(int n, byte[] byArray) throws PigpioException {
        byte[] byArray2 = (byte[])byArray.clone();
        this.nrfSpiWrite(0x20 | 0x1F & n, byArray2);
    }

    public void writeByteRegister(int n, byte by) throws PigpioException {
        byte[] byArray = new byte[]{by};
        this.writeRegister(n, byArray);
    }

    public int write(byte[] byArray) throws PigpioException {
        byte by;
        byte[] byArray2 = (byte[])byArray.clone();
        int n = 0;
        this.ceLow();
        if (!this.dynPayloadEnabled && byArray2.length < this.payloadSize) {
            byArray2 = Arrays.copyOf(byArray2, this.payloadSize);
        }
        byte by2 = this.readByteRegister(0);
        this.writeByteRegister(0, (byte)((by2 | this.BV(1)) & ~this.BV(0)));
        this.pigpio.gpioDelay(2L, 1);
        this.nrfSpiWrite(160, byArray2);
        this.ceHigh();
        this.pigpio.gpioDelay(150L, 0);
        this.pigpio.gpioDelay(20L, 0);
        this.ceLow();
        long l = System.currentTimeMillis() + 500L;
        while (((by = this.readByteRegister(7)) & (byte)(this.BV(5) | this.BV(4))) == 0 && System.currentTimeMillis() < l) {
        }
        if ((by & this.BV(5)) == 0) {
            n = (by & this.BV(4)) > 0 ? 1 : 2;
        }
        this.writeByteRegister(7, (byte)(by | this.BV(5) | this.BV(4)));
        this.powerDown();
        return n;
    }

    public void send(byte[] byArray) throws PigpioException {
        byte[] byArray2 = (byte[])byArray.clone();
        if (!this.dynPayloadEnabled && byArray2.length < this.payloadSize) {
            byArray2 = Arrays.copyOf(byArray2, this.payloadSize);
        }
        while (this.isSending()) {
        }
        this.ceLow();
        this.powerUpTx();
        this.nrfSpiWrite(160, byArray2);
        this.pigpio.gpioDelay(100L);
        this.ceLow();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isSending() throws PigpioException {
        if (this.transmitMode) {
            byte by = this.getStatus();
            if ((by & 0x30) != 0) {
                this.transmitFinished();
                return false;
            }
            return true;
        }
        return false;
    }

    public byte getStatus() throws PigpioException {
        return this.readByteRegister(7);
    }

    public byte getConfig() throws PigpioException {
        return this.readByteRegister(0);
    }

    public byte getChannel() throws PigpioException {
        return this.readByteRegister(5);
    }

    public int getAddressWidth() throws PigpioException {
        byte by = this.readByteRegister(3);
        int n = -1;
        switch (by & 3) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
            }
        }
        return n;
    }

    public byte[][] getRXAddresses() throws PigpioException {
        byte[][] byArray = new byte[6][5];
        this.readRegister(10, byArray[0]);
        this.readRegister(11, byArray[1]);
        this.readRegister(12, byArray[2]);
        this.readRegister(13, byArray[3]);
        this.readRegister(14, byArray[4]);
        this.readRegister(15, byArray[5]);
        return byArray;
    }

    public byte[] getTXAddress() throws PigpioException {
        byte[] byArray = new byte[5];
        this.readRegister(16, byArray);
        return byArray;
    }

    public void setAddressWidth(int n) throws PigpioException {
        switch (n) {
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            default: {
                n = 3;
            }
        }
        this.writeByteRegister(3, (byte)n);
    }

    public byte getAutomaticRetransmission() throws PigpioException {
        return this.readByteRegister(4);
    }

    public byte getFIFOStatus() throws PigpioException {
        return this.readByteRegister(23);
    }

    private void flushTx() throws PigpioException {
        this.nrfSpiWrite(225, null);
    }

    private void transmitFinished() throws PigpioException {
        this.transmitMode = false;
        this.setRegisterBits(7, (byte)(this.BV(5) | this.BV(4)));
    }

    private void powerUpRx() throws PigpioException {
        this.ceLow();
        this.transmitFinished();
        this.setRegisterBits(0, (byte)(this.BV(1) | this.BV(0) | this.BV(6)));
        this.setRegisterBits(7, (byte)this.BV(6));
        this.ceHigh();
        this.pigpio.gpioDelay(50L, 1);
        this.ceLow();
    }

    private void flushRx() throws PigpioException {
        this.nrfSpiWrite(226, null);
    }

    public void startListening() throws PigpioException {
        byte by = this.readByteRegister(0);
        this.transmitMode = false;
        this.writeByteRegister(0, (byte)(by | this.BV(1) | this.BV(0)));
        this.writeByteRegister(7, (byte)(this.BV(6) | this.BV(5) | this.BV(4)));
        this.flushRx();
        this.flushTx();
        this.ceHigh();
    }

    public void stopListening() throws PigpioException {
        this.ceLow();
        this.flushTx();
        this.flushRx();
    }

    private void powerUpTx() throws PigpioException {
        this.transmitMode = true;
        byte by = this.readByteRegister(0);
        this.writeByteRegister(0, (byte)(by | this.BV(1) & ~this.BV(0)));
        this.ceHigh();
        this.pigpio.gpioDelay(200L, 1);
    }

    public void powerDown() throws PigpioException {
        this.clearRegisterBits(0, (byte)2);
        this.transmitMode = false;
    }

    private void nrfSpiWrite(int n, byte[] byArray) throws PigpioException {
        this.csnLow();
        byte[] byArray2 = new byte[]{(byte)n};
        this.pigpio.spiXfer(this.handle, byArray2, byArray2);
        if (byArray != null) {
            this.pigpio.spiXfer(this.handle, byArray, byArray);
        }
        this.csnHigh();
        this.pigpio.gpioDelay(1L, 1);
    }

    private void ceHigh() throws PigpioException {
        this.pigpio.gpioWrite(this.cePin, true);
    }

    private void ceLow() throws PigpioException {
        this.pigpio.gpioWrite(this.cePin, false);
    }

    private void cePulse(long l) throws PigpioException {
        this.pigpio.gpioTrigger(this.cePin, l, true);
    }

    private void csnHigh() throws PigpioException {
        this.pigpio.gpioWrite(this.csnPin, true);
    }

    private void csnLow() throws PigpioException {
        this.pigpio.gpioWrite(this.csnPin, false);
    }

    public void startTestCarrier(int n, int n2) throws PigpioException {
        this.powerUpTx();
        this.setRegisterBits(6, (byte)-112);
        this.setChannel(n);
        this.setPALevel(n2);
        this.ceHigh();
    }

    public void stopTestCarrier() throws PigpioException {
        this.ceLow();
        this.powerDown();
        this.clearRegisterBits(6, (byte)-112);
    }

    public boolean testRPD() throws PigpioException {
        return (this.readByteRegister(9) & 1) == 1;
    }

    private int BV(int n) {
        return 1 << n;
    }

    public String statusToString(byte by) {
        String string = "";
        string = string + "RX_DR: " + this.bitSet(by, 6);
        string = string + ", TX_DS: " + this.bitSet(by, 5);
        string = string + ", MAX_RT: " + this.bitSet(by, 4);
        string = string + ", RX_P_NO: " + ((by & 0xE) >> 1);
        string = string + ", TX_FULL: " + this.bitSet(by, 5);
        return string;
    }

    public String configToString(byte by) {
        String string = "";
        string = string + "RX IRQ allowed: " + this.bitSet(by, 6);
        string = string + ", TX IRQ allowed: " + this.bitSet(by, 5);
        string = string + ", Max retransmits IRQ allowed: " + this.bitSet(by, 4);
        string = string + ", CRC enabled: " + this.bitSet(by, 3);
        string = string + ", CRC encoding scheme: " + this.bitSet(by, 2);
        string = string + ", Power up: " + this.bitSet(by, 1);
        string = string + ", RX(1)/TX(0): " + this.bitSet(by, 0);
        return string;
    }

    public String setupRetrToString(byte by) {
        String string = "";
        string = string + "Delay: " + (((by & 0xF0) >> 4) * 250 + 250);
        string = string + ", Auto retransmit count: " + (by & 0xF);
        return string;
    }

    public String fifoStatusToString(byte by) {
        String string = "";
        string = string + "Reuse: " + this.bitSet(by, 6);
        string = string + ", TX Full: " + this.bitSet(by, 5);
        string = string + ", TX Empty: " + this.bitSet(by, 4);
        string = string + ", RX Full: " + this.bitSet(by, 1);
        string = string + ", RX Empty: " + this.bitSet(by, 0);
        return string;
    }

    public String dataRateToString(int n) {
        switch (n) {
            case 0: {
                return "1 Mbps";
            }
            case 1: {
                return "2 Mbps";
            }
            case 2: {
                return "256 kbps";
            }
            case 17: {
                return "reserved";
            }
        }
        return "???";
    }

    private String bitSet(byte by, int n) {
        return (by & this.BV(n)) != 0 ? "1" : "0";
    }

    public void printDetails(PrintStream printStream) {
        try {
            byte by3;
            byte by2 = this.readByteRegister(7);
            printStream.println("STATUS          = 0x" + String.format("%02x", by2) + "  " + String.format("%8s", Integer.toBinaryString(by2 & 0xFF)).replace(' ', '0'));
            byte[][] byArray = this.getRXAddresses();
            printStream.println("RX_ADDR_P0-1    = 0x" + Utils.bytesToHex(byArray[0]) + "  0x" + Utils.bytesToHex(byArray[1]));
            printStream.print("RX_ADDR_P2-5    = ");
            for (int i = 2; i < 6; ++i) {
                printStream.print("0x" + String.format("%02x", byArray[i][0]) + "  ");
            }
            printStream.println();
            byte[] byArray2 = this.getTXAddress();
            printStream.println("TX_ADDR         = 0x" + Utils.bytesToHex(byArray2));
            byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0};
            this.readRegister(17, byArray3);
            printStream.print("RX_PW_P0-6      = ");
            for (byte by3 : byArray3) {
                printStream.print("0x" + String.format("%02x", by3) + "  ");
            }
            printStream.println();
            byte by4 = this.readByteRegister(1);
            printStream.println("EN_AA           = 0x" + String.format("%02x", by4) + "  " + String.format("%8s", Integer.toBinaryString(by4 & 0xFF)).replace(' ', '0'));
            int n = this.readByteRegister(2);
            printStream.println("EN_RXADDR       = 0x" + String.format("%02x", (byte)n) + "  " + String.format("%8s", Integer.toBinaryString(n & 0xFF)).replace(' ', '0'));
            int n2 = this.getChannel();
            printStream.println("RF_CH           = 0x" + String.format("%02x", (byte)n2));
            by3 = this.readByteRegister(6);
            printStream.println("RF_SETUP        = 0x" + String.format("%02x", by3) + "  " + String.format("%8s", Integer.toBinaryString(by3 & 0xFF)).replace(' ', '0'));
            byte by5 = this.getConfig();
            printStream.println("CONFIG          = 0x" + String.format("%02x", by5) + "  " + String.format("%8s", Integer.toBinaryString(by5 & 0xFF)).replace(' ', '0'));
            byte by6 = this.readByteRegister(28);
            byte by7 = this.readByteRegister(29);
            printStream.println("DYNPD/FEATURE   = 0x" + String.format("%02x", by6) + " 0x" + String.format("%02x", by7));
            int n3 = 0;
            if ((by3 & 0x20) > 0) {
                n3 = (byte)(n3 + 2);
            }
            if ((by3 & 8) > 0) {
                n3 = (byte)(n3 + 1);
            }
            printStream.println("Data Rate       = " + this.dataRateToString(n3));
            printStream.println("MODEL           = ???");
            printStream.print("CRC Length      = ");
            if ((by5 & 4) == 4) {
                printStream.println("16 bits");
            } else {
                printStream.println("8 bits");
            }
            printStream.println("PA Power        = ???");
            byte by8 = this.readByteRegister(4);
            printStream.println("SETUP_RETR      = 0x" + String.format("%02x", by8) + "  " + String.format("%8s", Integer.toBinaryString(by8 & 0xFF)).replace(' ', '0'));
            printStream.println();
            printStream.println(this.setupRetrToString(this.getAutomaticRetransmission()));
            printStream.println("RF Channel      = " + this.getChannel());
            printStream.println("Address widths  = " + this.getAddressWidth() + " bytes");
        }
        catch (PigpioException pigpioException) {
            printStream.println(pigpioException);
        }
    }

    public String getDetails() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.printDetails(printStream);
        return byteArrayOutputStream.toString();
    }
}

