/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.GPIO;
import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.WrongModeException;

public class SP0256 {
    private JPigpio pigpio;
    private GPIO aldGpio;
    private GPIO lrqGpio;
    private GPIO a1Gpio;
    private GPIO a2Gpio;
    private GPIO a3Gpio;
    private GPIO a4Gpio;
    private GPIO a5Gpio;
    private GPIO a6Gpio;

    public SP0256(JPigpio jPigpio, GPIO gPIO, GPIO gPIO2, GPIO gPIO3, GPIO gPIO4, GPIO gPIO5, GPIO gPIO6, GPIO gPIO7, GPIO gPIO8) throws PigpioException {
        this.pigpio = jPigpio;
        this.aldGpio = gPIO;
        this.lrqGpio = gPIO2;
        this.a1Gpio = gPIO3;
        this.a2Gpio = gPIO4;
        this.a3Gpio = gPIO5;
        this.a4Gpio = gPIO6;
        this.a5Gpio = gPIO7;
        this.a6Gpio = gPIO8;
        if (gPIO.getDirection() != 1) {
            throw new WrongModeException(gPIO.getPin());
        }
        if (gPIO2.getDirection() != 0) {
            throw new WrongModeException(gPIO2.getPin());
        }
        if (gPIO3.getDirection() != 1) {
            throw new WrongModeException(gPIO3.getPin());
        }
        if (gPIO4.getDirection() != 1) {
            throw new WrongModeException(gPIO4.getPin());
        }
        if (gPIO5.getDirection() != 1) {
            throw new WrongModeException(gPIO5.getPin());
        }
        if (gPIO6.getDirection() != 1) {
            throw new WrongModeException(gPIO6.getPin());
        }
        if (gPIO7.getDirection() != 1) {
            throw new WrongModeException(gPIO7.getPin());
        }
        if (gPIO8.getDirection() != 1) {
            throw new WrongModeException(gPIO8.getPin());
        }
        gPIO.setValue(1);
    }

    public void sayAlophone(byte by) throws PigpioException {
        this.a1Gpio.setValue(Utils.isSet(by, 0));
        this.a2Gpio.setValue(Utils.isSet(by, 1));
        this.a3Gpio.setValue(Utils.isSet(by, 2));
        this.a4Gpio.setValue(Utils.isSet(by, 3));
        this.a5Gpio.setValue(Utils.isSet(by, 4));
        this.a6Gpio.setValue(Utils.isSet(by, 5));
        while (this.lrqGpio.getValue()) {
            this.pigpio.gpioDelay(20000L);
        }
        this.aldGpio.setValue(0);
        this.pigpio.gpioDelay(10000L);
        this.aldGpio.setValue(1);
    }
}

