/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;

public class Servo {
    private JPigpio pigpio;
    private int minVal;
    private int maxVal;
    private int gpio;
    private int minPulseWidth;
    private int maxPulseWidth;

    public Servo(JPigpio jPigpio, int n, int n2, int n3) {
        this.pigpio = jPigpio;
        this.gpio = n;
        this.minVal = n2;
        this.maxVal = n3;
        this.minPulseWidth = 500;
        this.maxPulseWidth = 2500;
    }

    public void setValue(int n) throws PigpioException {
        int n2 = Utils.mapToInt(n, this.minVal, this.maxVal, this.minPulseWidth, this.maxPulseWidth);
        System.out.println("Mapped val = " + n2);
        this.pigpio.gpioServo(this.gpio, n2);
    }

    public void stop() throws PigpioException {
        this.pigpio.gpioServo(this.gpio, 0);
    }
}

