/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.WrongModeException;

public class Stepper {
    private JPigpio pigpio;
    private int blueGpio;
    private int pinkGpio;
    private int yellowGpio;
    private int orangeGpio;
    private int step = 0;
    private int[][] stepData = new int[][]{{1, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 1, 1}, {1, 0, 0, 1}};

    public Stepper(JPigpio jPigpio, int n, int n2, int n3, int n4) throws PigpioException {
        this.pigpio = jPigpio;
        this.blueGpio = n;
        this.pinkGpio = n2;
        this.yellowGpio = n3;
        this.orangeGpio = n4;
        if (jPigpio.gpioGetMode(n) != 1) {
            throw new WrongModeException(n);
        }
        if (jPigpio.gpioGetMode(n2) != 1) {
            throw new WrongModeException(n2);
        }
        if (jPigpio.gpioGetMode(n3) != 1) {
            throw new WrongModeException(n3);
        }
        if (jPigpio.gpioGetMode(n4) != 1) {
            throw new WrongModeException(n4);
        }
        this.setData();
    }

    private void setData() throws PigpioException {
        this.pigpio.gpioWrite(this.blueGpio, this.stepData[this.step][0] != 0);
        this.pigpio.gpioWrite(this.pinkGpio, this.stepData[this.step][1] != 0);
        this.pigpio.gpioWrite(this.yellowGpio, this.stepData[this.step][2] != 0);
        this.pigpio.gpioWrite(this.orangeGpio, this.stepData[this.step][3] != 0);
    }

    public void forward() throws PigpioException {
        this.step = (this.step + 1) % 4;
        this.setData();
    }

    public void backward() throws PigpioException {
        this.step = (this.step - 1) % 4;
        this.setData();
    }
}

