/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.GPIO;
import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.WrongModeException;

public class TM1638 {
    private JPigpio pigpio;
    private GPIO stbGpio;
    private GPIO clkGpio;
    private GPIO dioGpio;
    private boolean isTestMode;
    private boolean isFixedAddress;
    private boolean isReadKeys;
    private boolean isDisplayOn;
    private int brightness;
    private final byte DATA_COMMAND = (byte)64;
    private final byte ADDRESS_COMMAND = (byte)-64;
    private final byte DISPLAY_COMMAND = (byte)-128;
    private final byte TEST_MODE = (byte)8;
    private final byte FIXED_ADDRESS = (byte)4;
    private final byte READ_KEYS = (byte)2;
    private final byte DISPLAY_ON = (byte)8;
    private final byte[] NUMBER_FONT = new byte[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111, 119, 124, 57, 94, 121, 113};

    public TM1638(JPigpio jPigpio, GPIO gPIO, GPIO gPIO2, GPIO gPIO3) throws PigpioException {
        this.pigpio = jPigpio;
        this.stbGpio = gPIO;
        this.clkGpio = gPIO2;
        this.dioGpio = gPIO3;
        this.isTestMode = false;
        this.isFixedAddress = false;
        this.isReadKeys = false;
        this.isDisplayOn = false;
        this.brightness = 7;
        if (gPIO.getDirection() != 1) {
            throw new WrongModeException(gPIO.getPin());
        }
        if (gPIO2.getDirection() != 1) {
            throw new WrongModeException(gPIO2.getPin());
        }
        if (gPIO3.getDirection() != 1) {
            throw new WrongModeException(gPIO3.getPin());
        }
        gPIO2.setValue(true);
        this.setStrobe(true);
        jPigpio.gpioDelay(100L);
        this.setStrobe(false);
        this.setDataCommand(false, false, false);
        this.sendDataCommand();
        this.setStrobe(true);
        jPigpio.gpioDelay(100L);
        this.setStrobe(false);
        this.setDisplay(true);
        this.setBrightness(7);
        this.sendDisplayCommand();
        this.setStrobe(true);
        jPigpio.gpioDelay(100L);
        this.setStrobe(false);
        this.sendAddress(0);
        for (int i = 0; i < 16; ++i) {
            this.writeByte((byte)-128);
        }
        this.setStrobe(true);
    }

    private void writeDigit(int n) throws PigpioException {
        byte by = this.NUMBER_FONT[n & 0xF];
        this.writeByte(by);
    }

    public void writeNumber(int n) throws PigpioException {
        int n2;
        assert (n >= 0);
        for (n2 = 10000000; n2 >= 10 && n <= n2; n2 /= 10) {
        }
        this.setStrobe(false);
        this.sendAddress(0);
        for (int i = 0; i < 8; ++i) {
            if (n2 > 0) {
                this.writeDigit(n / n2);
                n %= n2;
                n2 /= 10;
            } else {
                this.writeByte((byte)0);
            }
            this.writeByte((byte)0);
        }
        this.setStrobe(true);
    }

    private void setDataCommand(boolean bl, boolean bl2, boolean bl3) {
        this.isTestMode = bl;
        this.isFixedAddress = bl2;
        this.isReadKeys = bl3;
    }

    private void sendDataCommand() throws PigpioException {
        byte by = 64;
        if (this.isTestMode) {
            by = (byte)(by | 8);
        }
        if (this.isFixedAddress) {
            by = (byte)(by | 4);
        }
        if (this.isReadKeys) {
            by = (byte)(by | 2);
        }
        this.writeByte(by);
    }

    private void sendAddress(int n) throws PigpioException {
        byte by = (byte)(n & 0xF | 0x40);
        this.writeByte(by);
    }

    private void setDisplay(boolean bl) {
        this.isDisplayOn = bl;
    }

    private void setBrightness(int n) {
        this.brightness = n & 7;
    }

    private void sendDisplayCommand() throws PigpioException {
        byte by = -128;
        if (this.isDisplayOn) {
            by = (byte)(by | 8);
        }
        by = (byte)(by | (byte)(this.brightness & 7));
        this.writeByte(by);
    }

    private void writeByte(byte by) throws PigpioException {
        this.pigpio.gpioShiftOut(this.dioGpio, this.clkGpio, false, false, by);
    }

    private void setStrobe(boolean bl) throws PigpioException {
        this.stbGpio.setValue(bl);
    }
}

