/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.devices;

import eu.xeli.jpigpio.FileIO;
import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.WrongModeException;
import eu.xeli.jpigpio.impl.SPI;
import java.io.File;
import java.io.IOException;

public class VS1053 {
    private final boolean DEVICE_ENABLE = false;
    private final boolean DEVICE_DISABLE = true;
    private final int READ = 3;
    private final int WRITE = 2;
    private final int SCI_MODE = 0;
    private final int SCI_STATUS = 1;
    private final int SCI_BASS = 2;
    private final int SCI_CLOCKF = 3;
    private final int SCI_DECODE_TIME = 4;
    private final int SCI_AUDATA = 5;
    private final int SCI_WRAM = 6;
    private final int SCI_WRAMADDR = 7;
    private final int SCI_HDAT0 = 8;
    private final int SCI_HDAT1 = 9;
    private final int SCI_AIADDR = 10;
    private final int SCI_VOL = 11;
    private final int SCI_AICTRL0 = 12;
    private final int SCI_AICTRL1 = 13;
    private final int SCI_AICTRL2 = 14;
    private final int SCI_AICTRL3 = 15;
    private final int SCI_RECRATE = 12;
    private final int SCI_RECGAIN = 13;
    private final int SCI_RECMAXAUTO = 14;
    private final int SCI_RECMODE = 15;
    private final int SM_DIFF_B = 0;
    private final int SM_LAYER12_B = 1;
    private final int SM_RESET_B = 2;
    private final int SM_CANCEL_B = 3;
    private final int SM_EARSPEAKER_LO_B = 4;
    private final int SM_TESTS_B = 5;
    private final int SM_STREAM_B = 6;
    private final int SM_EARSPEAKER_HI_B = 7;
    private final int SM_DACT_B = 8;
    private final int SM_SDIORD_B = 9;
    private final int SM_SDISHARE_B = 10;
    private final int SM_SDINEW_B = 11;
    private final int SM_ADPCM_B = 12;
    private final int SM_LINE1_B = 14;
    private final int SM_CLK_RANGE_B = 15;
    private final int SM_DIFF = 1;
    private final int SM_LAYER12 = 2;
    private final int SM_RESET = 4;
    private final int SM_CANCEL = 8;
    private final int SM_EARSPEAKER_LO = 16;
    private final int SM_TESTS = 32;
    private final int SM_STREAM = 64;
    private final int SM_EARSPEAKER_HI = 128;
    private final int SM_DACT = 256;
    private final int SM_SDIORD = 512;
    private final int SM_SDISHARE = 1024;
    private final int SM_SDINEW = 2048;
    private final int SM_ADPCM = 4096;
    private final int SM_LINE1 = 16384;
    private final int SM_CLK_RANGE = 32768;
    private final int SM_ICONF_BITS = 2;
    private final int SM_ICONF_MASK = 192;
    private final int SM_EARSPEAKER_1103_BITS = 2;
    private final int SM_EARSPEAKER_1103_MASK = 12288;
    private final int SS_REFERENCE_SEL_B = 0;
    private final int SS_AD_CLOCK_B = 1;
    private final int SS_APDOWN1_B = 2;
    private final int SS_APDOWN2_B = 3;
    private final int SS_VER_B = 4;
    private final int SS_VCM_DISABLE_B = 10;
    private final int SS_VCM_OVERLOAD_B = 11;
    private final int SS_SWING_B = 12;
    private final int SS_DO_NOT_JUMP_B = 15;
    private final int SS_REFERENCE_SEL = 1;
    private final int SS_AVOL = 1;
    private final int SS_AD_CLOCK = 2;
    private final int SS_APDOWN1 = 4;
    private final int SS_APDOWN2 = 8;
    private final int SS_VER = 16;
    private final int SS_VCM_DISABLE = 1024;
    private final int SS_VCM_OVERLOAD = 2048;
    private final int SS_SWING = 4096;
    private final int SS_DO_NOT_JUMP = 32768;
    private final int SS_SWING_BITS = 3;
    private final int SS_SWING_MASK = 28672;
    private final int SS_VER_BITS = 4;
    private final int SS_VER_MASK = 240;
    private final int SS_AVOL_BITS = 2;
    private final int SS_AVOL_MASK = 3;
    private final int SS_VER_VS1001 = 0;
    private final int SS_VER_VS1011 = 16;
    private final int SS_VER_VS1002 = 32;
    private final int SS_VER_VS1003 = 48;
    private final int SS_VER_VS1053 = 64;
    private final int SS_VER_VS8053 = 64;
    private final int SS_VER_VS1033 = 80;
    private final int SS_VER_VS1063 = 96;
    private final int SS_VER_VS1103 = 112;
    private final int ST_AMPLITUDE_B = 12;
    private final int ST_FREQLIMIT_B = 8;
    private final int SB_AMPLITUDE_B = 4;
    private final int SB_FREQLIMIT_B = 0;
    private final int ST_AMPLITUDE = 4096;
    private final int ST_FREQLIMIT = 256;
    private final int SB_AMPLITUDE = 16;
    private final int SB_FREQLIMIT = 1;
    private final int ST_AMPLITUDE_BITS = 4;
    private final int ST_AMPLITUDE_MASK = 61440;
    private final int ST_FREQLIMIT_BITS = 4;
    private final int ST_FREQLIMIT_MASK = 3840;
    private final int SB_AMPLITUDE_BITS = 4;
    private final int SB_AMPLITUDE_MASK = 240;
    private final int SB_FREQLIMIT_BITS = 4;
    private final int SB_FREQLIMIT_MASK = 15;
    private final int SC_MULT_B = 13;
    private final int SC_ADD_B = 11;
    private final int SC_FREQ_B = 0;
    private final int SC_MULT = 8192;
    private final int SC_ADD = 2048;
    private final int SC_FREQ = 1;
    private final int SC_MULT_BITS = 3;
    private final int SC_MULT_MASK = 57344;
    private final int SC_ADD_BITS = 2;
    private final int SC_ADD_MASK = 6144;
    private final int SC_FREQ_BITS = 11;
    private final int SC_FREQ_MASK = 2047;
    private JPigpio pigpio;
    private SPI sciSpi;
    private SPI sdiSpi;
    private int gpioDREQ;

    public VS1053(JPigpio jPigpio, int n) throws PigpioException {
        this.pigpio = jPigpio;
        this.gpioDREQ = n;
        if (jPigpio.gpioGetMode(n) != 0) {
            throw new WrongModeException(n);
        }
        this.sciSpi = new SPI(jPigpio, 0, 2000000, 0);
        this.sdiSpi = new SPI(jPigpio, 1, 2000000, 0);
    }

    private int readSci(int n) throws PigpioException {
        this.waitForReady();
        byte[] byArray = new byte[]{3, (byte)n, 0, 0};
        byte[] byArray2 = new byte[4];
        this.sciSpi.xfer(byArray, byArray2);
        byte[] byArray3 = new byte[]{byArray2[2], byArray2[3]};
        return Utils.byteWordToInt(byArray3);
    }

    private void writeSci(int n, int n2) throws PigpioException {
        this.waitForReady();
        byte[] byArray = new byte[]{2, (byte)n, (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        this.sciSpi.write(byArray);
    }

    private void writeSdi(byte[] byArray) throws PigpioException {
        this.waitForReady();
        this.sdiSpi.write(byArray);
    }

    public int getMode() throws PigpioException {
        return this.readSci(0);
    }

    public void setMode(int n) throws PigpioException {
        this.writeSci(0, n);
    }

    public int getStatus() throws PigpioException {
        return this.readSci(1);
    }

    public int getAudata() throws PigpioException {
        return this.readSci(5);
    }

    public void setAudata(int n) throws PigpioException {
        this.writeSci(5, n);
    }

    public int getVolume() throws PigpioException {
        return this.readSci(11);
    }

    public void setVolume(int n) throws PigpioException {
        int n2 = (n & 0xFF) << 8 | n & 0xFF;
        this.writeSci(11, n2);
    }

    public int getClockF() throws PigpioException {
        return this.readSci(3);
    }

    public void setClockF(int n) throws PigpioException {
        this.writeSci(3, n);
    }

    public int getBass() throws PigpioException {
        this.waitForReady();
        return this.readSci(2);
    }

    public void setLine(boolean bl) throws PigpioException {
        if (bl) {
            this.setMode(Utils.setBit(this.getMode(), 14));
        } else {
            this.setMode(Utils.clearBit(this.getMode(), 14));
        }
    }

    public void setTestMode(boolean bl) throws PigpioException {
        if (bl) {
            this.setMode(Utils.setBit(this.getMode(), 5));
        } else {
            this.setMode(Utils.clearBit(this.getMode(), 5));
        }
    }

    public void waitForReady() throws PigpioException {
        while (!this.isReady()) {
        }
    }

    private boolean isReady() throws PigpioException {
        return this.pigpio.gpioRead(this.gpioDREQ);
    }

    public void softReset() throws PigpioException {
        this.setMode(Utils.setBit(this.getMode(), 2));
    }

    public String format(int n, String string) {
        long l = Integer.toUnsignedLong(n);
        String string2 = "";
        switch (string) {
            case "AUDATA": {
                string2 = Utils.isSet(n, 0) ? string2 + "Stereo" : string2 + "Mono";
                return String.format("(0x%x): %dHz %s", l, l & 0xFFFFFFFFFFFFFFFEL, string2);
            }
            case "MODE": {
                string2 = Utils.isSet(n, 0) ? string2 + "Left_Channel_Inverted" : string2 + "Normal_in_phase_audio";
                if (Utils.isSet(n, 1)) {
                    string2 = string2 + " Allow_MPEG_1&2";
                }
                if (Utils.isSet(n, 5)) {
                    string2 = string2 + " SDI_Tests_allowed";
                }
                if (Utils.isSet(n, 6)) {
                    string2 = string2 + " Streaming";
                }
                string2 = Utils.isSet(n, 8) ? string2 + " DCLK_Active_Edge_Falling" : string2 + " DCLK_Active_Edge_Rising";
                string2 = Utils.isSet(n, 9) ? string2 + " LSB_First" : string2 + " MSB_First";
                if (Utils.isSet(n, 10)) {
                    string2 = string2 + " Share_SPI_Select";
                }
                if (Utils.isSet(n, 11)) {
                    string2 = string2 + " SDI_New";
                }
                if (Utils.isSet(n, 12)) {
                    string2 = string2 + " PCM/ADPCM_Recording_Active";
                }
                string2 = Utils.isSet(n, 14) ? string2 + " LINE1" : string2 + " MICP";
                string2 = Utils.isSet(n, 15) ? string2 + " 24..26MHz" : string2 + " 12..13MHz";
                return string2;
            }
        }
        System.out.println("Unknown formatting type: " + string);
        return Utils.int16ToBinary(n);
    }

    public void startSineTest() throws PigpioException {
        byte[] byArray = new byte[]{83, -17, 99, 126, 0, 0, 0, 0};
        this.writeSdi(byArray);
    }

    public void endSineTest() throws PigpioException {
        byte[] byArray = new byte[]{69, 120, 105, 116, 0, 0, 0, 0};
        this.writeSdi(byArray);
    }

    public void memoryTest() throws PigpioException {
        byte[] byArray = new byte[]{77, -22, 109, 84, 0, 0, 0, 0};
        this.writeSdi(byArray);
        this.pigpio.gpioDelay(5L, 2);
        int n = this.readSci(8);
        System.out.println(String.format("memoryTest: 0x%x", n));
    }

    private void setRWAddress(int n) throws PigpioException {
        this.writeSci(7, n);
    }

    private int readRamFromAddress(int n) throws PigpioException {
        this.setRWAddress(n);
        return this.readRam();
    }

    private void writeRam(int n) throws PigpioException {
        this.writeSci(6, n);
    }

    private int readRam() throws PigpioException {
        return this.readSci(6);
    }

    public void disableMidi() throws PigpioException {
        int n = this.getAudata();
        if (n != 44101) {
            System.out.println("Skipping midi setup");
            return;
        }
        this.setRWAddress(49175);
        n = this.readSci(6);
        System.out.println(String.format("Current GPIO direction: %s", Utils.int16ToBinary(n)));
        this.setRWAddress(49177);
        n = this.readSci(6);
        System.out.println(String.format("Current GPIO values: %s", Utils.int16ToBinary(n)));
        this.setRWAddress(49175);
        this.writeRam(3);
        this.setRWAddress(49177);
        this.writeRam(0);
        this.softReset();
    }

    public void dump() throws PigpioException {
        int n = this.getMode();
        System.out.println("Mode: " + Utils.int16ToBinary(n));
        System.out.println("Mode: " + this.format(n, "MODE"));
        System.out.println("Status: " + Utils.int16ToBinary(this.getStatus()));
        int n2 = this.getAudata();
        System.out.println("Audata: " + Utils.int16ToBinary(n2));
        System.out.println("Audata: " + this.format(n2, "AUDATA"));
        System.out.println("Volume: " + Utils.int16ToBinary(this.getVolume()));
        System.out.println("Bass: " + Utils.int16ToBinary(this.getBass()));
        System.out.println("ClockF: " + Utils.int16ToBinary(this.getClockF()));
        Parameters parameters = new Parameters();
        parameters.retrieve();
        System.out.println("Parameters: " + parameters);
        System.out.println("---");
    }

    public void playFile(File file) throws PigpioException {
        FileIO fileIO = new FileIO(file);
        long l = this.pigpio.gpioTick();
        try {
            byte[] byArray;
            System.out.println("Playing audio file: " + file);
            while ((byArray = fileIO.read(32)).length != 0) {
                this.writeSdi(byArray);
                if (this.pigpio.gpioTick() - l <= 5000000L) continue;
                this.dump();
                l = this.pigpio.gpioTick();
            }
            fileIO.close();
            System.out.println("End of playing audio file.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("End of audio ...");
    }

    private class Parameters {
        private int version;
        private int config1;
        private int playSpeed;
        private int byteRate;
        private int endFillByte;

        private Parameters() {
        }

        public void retrieve() throws PigpioException {
            this.version = VS1053.this.readRamFromAddress(7682);
            this.config1 = VS1053.this.readRamFromAddress(7683);
            this.playSpeed = VS1053.this.readRamFromAddress(7684);
            this.byteRate = VS1053.this.readRamFromAddress(7685);
            this.endFillByte = VS1053.this.readRamFromAddress(7686);
        }

        public String toString() {
            String string = "";
            string = string + String.format("version: %d", this.version);
            string = string + String.format(", config1: %x", this.config1);
            string = string + String.format(", playSpeed: %d", this.playSpeed);
            string = string + String.format(", byteRate: %d", this.byteRate);
            string = string + String.format(", endFillByte: %d", this.endFillByte);
            return string;
        }
    }
}

