/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.impl;

import eu.xeli.jpigpio.GPIO;
import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;

public abstract class CommonPigpio
implements JPigpio {
    @Override
    public void gpioShiftOut(int n, int n2, boolean bl, byte by) throws PigpioException {
        this.gpioShiftOut(n, n2, true, bl, by);
    }

    @Override
    public void gpioShiftOut(GPIO gPIO, GPIO gPIO2, boolean bl, byte by) throws PigpioException {
        this.gpioShiftOut(gPIO, gPIO2, true, bl, by);
    }

    @Override
    public void gpioShiftOut(int n, int n2, boolean bl, boolean bl2, byte by) throws PigpioException {
        for (int i = 0; i < 8; ++i) {
            boolean bl3;
            if (!bl2) {
                bl3 = (by & 1) != 0;
                by = (byte)(by >> 1);
            } else {
                bl3 = (by & 0x80) != 0;
                by = (byte)(by << 1);
            }
            this.gpioWrite(n, bl3);
            this.gpioTrigger(n2, 10L, bl);
        }
    }

    @Override
    public void gpioShiftOut(GPIO gPIO, GPIO gPIO2, boolean bl, boolean bl2, byte by) throws PigpioException {
        for (int i = 0; i < 8; ++i) {
            boolean bl3;
            if (!bl2) {
                bl3 = (by & 1) != 0;
                by = (byte)(by >> 1);
            } else {
                bl3 = (by & 0x80) != 0;
                by = (byte)(by << 1);
            }
            gPIO.setValue(bl3);
            this.gpioTrigger(gPIO2.getPin(), 10L, bl);
        }
    }

    @Override
    public void gpioDelay(long l, int n) throws PigpioException {
        switch (n) {
            case 0: {
                this.gpioDelay(l);
                break;
            }
            case 2: {
                l *= 1000L;
            }
            case 1: {
                try {
                    Thread.sleep(l);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

