/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.impl;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;

public class SPI {
    private int handle;
    private JPigpio pigpio;
    private boolean debug;

    public SPI(JPigpio jPigpio, int n, int n2, int n3) throws PigpioException {
        this.pigpio = jPigpio;
        this.debug = false;
        this.handle = jPigpio.spiOpen(n, n2, n3);
    }

    public void close() throws PigpioException {
        this.pigpio.spiClose(this.handle);
    }

    public void read(byte[] byArray) throws PigpioException {
        this.pigpio.spiRead(this.handle, byArray);
        if (this.debug) {
            System.out.println("spiRead: " + Utils.dumpData(byArray));
        }
    }

    public void write(byte[] byArray) throws PigpioException {
        if (this.debug) {
            System.out.println("spiWrite: " + Utils.dumpData(byArray));
        }
        this.pigpio.spiWrite(this.handle, byArray);
    }

    public void xfer(byte[] byArray, byte[] byArray2) throws PigpioException {
        if (this.debug) {
            System.out.print("xfer: " + Utils.dumpData(byArray));
        }
        this.pigpio.spiXfer(this.handle, byArray, byArray2);
        if (this.debug) {
            System.out.println(" " + Utils.dumpData(byArray2));
        }
    }

    public byte xfer(byte by) throws PigpioException {
        byte[] byArray = new byte[]{by};
        byte[] byArray2 = new byte[1];
        this.xfer(byArray, byArray2);
        return byArray2[0];
    }
}

