/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.packet;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.packet.NotificationListener;
import eu.xeli.jpigpio.packet.Protocol;
import java.util.ArrayList;

public class Rf433rx {
    JPigpio pi;
    int rxGpio;
    NotificationListener cb;
    Protocol protocol;
    ArrayList<byte[]> datagrams = new ArrayList();

    public Rf433rx(JPigpio jPigpio, int n, Protocol protocol) throws PigpioException {
        this.pi = jPigpio;
        this.rxGpio = n;
        this.protocol = protocol;
        jPigpio.gpioSetMode(n, 0);
        this.setCallback(new RxNotificationListener(n, 2));
    }

    public void setCallback(NotificationListener notificationListener) throws PigpioException {
        this.cb = notificationListener;
        this.pi.addCallback(this.cb);
    }

    public byte[] get() throws IndexOutOfBoundsException {
        return this.datagrams.remove(0);
    }

    public int available() {
        return this.datagrams.size();
    }

    public void terminate() throws PigpioException {
        if (this.cb != null) {
            this.pi.removeCallback(this.cb);
            this.pi.setWatchdog(this.rxGpio, 0);
            this.cb = null;
        }
    }

    public int byteErrorCount() {
        return this.cb.byteErrorCount();
    }

    public int datagramErrorCount() {
        return this.cb.datagramErrorCount();
    }

    class RxNotificationListener
    extends NotificationListener {
        final int RX_STATE_IDLE = 0;
        final int RX_STATE_MSGSTARTFOUND = 1;
        final int RX_STATE_BYTESTARTFOUND = 2;
        final int RX_STATE_GETBYTE = 3;
        boolean datagramError;
        int messageTick;
        long lastTick;
        long pulse;
        int state;
        int repeatCount;
        boolean duplicate;
        int dataBit;
        int dataByte;
        byte[] datagram;
        int data;
        String pulses;

        RxNotificationListener(int n, int n2) {
            super(n, n2);
            this.RX_STATE_IDLE = 0;
            this.RX_STATE_MSGSTARTFOUND = 1;
            this.RX_STATE_BYTESTARTFOUND = 2;
            this.RX_STATE_GETBYTE = 3;
            this.datagramError = false;
            this.messageTick = 0;
            this.lastTick = 0L;
            this.pulse = 0L;
            this.state = 0;
            this.repeatCount = 0;
            this.duplicate = false;
            this.dataBit = 0;
            this.dataByte = 0;
            this.datagram = new byte[Rf433rx.this.protocol.DGRM_LENGTH];
            this.data = 0;
            this.pulses = "";
            try {
                this.lastTick = Rf433rx.this.pi.getCurrentTick();
            }
            catch (PigpioException pigpioException) {
                // empty catch block
            }
        }

        @Override
        public void alert(int n, int n2, long l) {
            int n3 = 0;
            ++this.count;
            JPigpio cfr_ignored_0 = Rf433rx.this.pi;
            if (n2 == 2) {
                try {
                    Rf433rx.this.pi.setWatchdog(Rf433rx.this.rxGpio, 0);
                }
                catch (PigpioException pigpioException) {
                    // empty catch block
                }
                return;
            }
            this.pulse = Utils.tickDiff(this.lastTick, l);
            this.lastTick = (int)l;
            if (this.pulse < (long)Rf433rx.this.protocol.RX_PULSE_TOOSHORT) {
                return;
            }
            if (this.state == 0 && this.pulse <= (long)Rf433rx.this.protocol.RX_PULSE_MSGGAP) {
                return;
            }
            if (this.pulse < (long)Rf433rx.this.protocol.RX_PULSE_ONE) {
                n3 = n2 + 2;
                this.pulses = this.pulses + "1";
            } else if (this.pulse < (long)Rf433rx.this.protocol.RX_PULSE_ZERO) {
                n3 = n2 + 4;
                this.pulses = this.pulses + "0";
            } else if (this.pulse > (long)Rf433rx.this.protocol.RX_PULSE_MSGGAP) {
                n3 = n2 + 6;
                this.pulses = this.pulses + " ";
            } else {
                n3 = 8;
            }
            switch (this.state) {
                case 0: {
                    if (n3 != 7) break;
                    this.state = 1;
                    this.duplicate = true;
                    break;
                }
                case 1: {
                    if (n3 == 2) break;
                    if (n3 == 3) {
                        this.dataByte = 0;
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (n3 == 2) break;
                    if (n3 == 3) {
                        this.data = 0;
                        this.dataBit = 0;
                        this.state = 3;
                        break;
                    }
                    if (n3 == 5) {
                        this.data = 0;
                        this.dataBit = 1;
                        this.state = 3;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (n3 != 2) {
                        if (n3 == 3) {
                            this.data = this.data << 1 | 1;
                            ++this.dataBit;
                        } else if (n3 == 5) {
                            this.data = this.data << 2 | 2;
                            this.dataBit += 2;
                        } else {
                            this.state = 0;
                        }
                    }
                    if (this.dataBit < 8) break;
                    this.data = Rf433rx.this.protocol.sym2nibble(this.data);
                    if (this.data < 0) {
                        this.datagramError = true;
                        ++this.byteErrorCount;
                    } else {
                        if (this.data != this.datagram[this.dataByte]) {
                            this.duplicate = false;
                            this.repeatCount = 0;
                        }
                        this.datagram[this.dataByte] = (byte)this.data;
                    }
                    ++this.dataByte;
                    this.dataBit = 0;
                    this.pulses = "";
                    if (this.dataByte >= Rf433rx.this.protocol.DGRM_LENGTH) {
                        if (Utils.tickDiff(this.messageTick, (int)this.lastTick) > (long)Rf433rx.this.protocol.DGRM_RX_TIMEOUT || this.messageTick == 0) {
                            this.repeatCount = 0;
                            this.duplicate = false;
                        } else if (this.duplicate) {
                            ++this.repeatCount;
                        }
                        if (this.repeatCount >= Rf433rx.this.protocol.DGRM_REPEAT_RX) {
                            this.repeatCount = 0;
                            this.duplicate = false;
                        }
                        if (!(!Rf433rx.this.protocol.DGRM_KEEP_ON_ENCODING_ERROR && this.datagramError || this.duplicate)) {
                            Rf433rx.this.datagrams.add(Utils.nibbles2bytes(this.datagram));
                        }
                        this.state = 0;
                        this.messageTick = (int)l;
                        if (this.datagramError) {
                            ++this.datagramErrorCount;
                        }
                        this.datagramError = false;
                        break;
                    }
                    this.state = 2;
                }
            }
        }
    }
}

