/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.packet;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.Pulse;
import eu.xeli.jpigpio.Utils;
import eu.xeli.jpigpio.packet.Protocol;
import java.util.ArrayList;

public class Rf433tx {
    JPigpio pi;
    int txGpio;
    int txBit;
    Protocol protocol;
    Transmitter transmitter;

    public Rf433tx(JPigpio jPigpio, int n, Protocol protocol) throws PigpioException {
        this.pi = jPigpio;
        this.txGpio = n;
        this.txBit = 1 << n;
        this.protocol = protocol;
        this.transmitter = new Transmitter(jPigpio);
        this.transmitter.start();
        jPigpio.waveClear();
        jPigpio.gpioSetMode(n, 1);
    }

    public ArrayList<Pulse> constructMessagePulses(byte[] byArray) {
        ArrayList<Pulse> arrayList = new ArrayList<Pulse>();
        arrayList.add(new Pulse(0, this.txBit, this.protocol.TX_PULSE_MSGGAP));
        arrayList.add(new Pulse(this.txBit, 0, this.protocol.TX_PULSE_HIGH));
        arrayList.add(new Pulse(0, this.txBit, this.protocol.TX_PULSE_HIGH));
        for (byte by : byArray) {
            arrayList.add(new Pulse(this.txBit, 0, this.protocol.TX_PULSE_HIGH));
            arrayList.add(new Pulse(0, this.txBit, this.protocol.TX_PULSE_HIGH));
            int n = this.protocol.nibble2sym(by);
            for (int n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                if ((n & 128 >> n2) != 0) {
                    arrayList.add(new Pulse(this.txBit, 0, this.protocol.TX_PULSE_HIGH));
                    arrayList.add(new Pulse(0, this.txBit, this.protocol.TX_PULSE_HIGH));
                    continue;
                }
                arrayList.add(new Pulse(0, 0, this.protocol.TX_PULSE_LOW));
            }
        }
        arrayList.add(new Pulse(this.txBit, 0, this.protocol.TX_PULSE_HIGH));
        arrayList.add(new Pulse(0, this.txBit, this.protocol.TX_PULSE_HIGH));
        return arrayList;
    }

    public int put(byte[] byArray) throws PigpioException {
        if (byArray.length != this.protocol.DATA_SIZE) {
            return -1;
        }
        return this.putNibbles(Utils.bytes2nibbles(byArray));
    }

    int putNibbles(byte[] byArray) throws PigpioException {
        int n = 0;
        if (byArray.length < this.protocol.DGRM_LENGTH) {
            return -1;
        }
        ArrayList<Pulse> arrayList = this.constructMessagePulses(byArray);
        this.transmitter.addWave(arrayList);
        return n;
    }

    public synchronized boolean ready() throws PigpioException {
        return this.transmitter.ready();
    }

    public void terminate() throws PigpioException {
        this.transmitter.stop();
        this.pi.waveClear();
    }

    class Transmitter
    implements Runnable {
        Thread thread;
        boolean stop = false;
        boolean error = false;
        boolean busy = false;
        Exception lastEx;
        JPigpio pi;
        ArrayList<ArrayList<Pulse>> wavePulses = new ArrayList();

        Transmitter(JPigpio jPigpio) {
            this.pi = jPigpio;
        }

        @Override
        public void run() {
            int n = -1;
            while (!this.stop) {
                try {
                    if (this.wavePulses.size() > 0 && !this.pi.waveTxBusy()) {
                        this.busy = true;
                        this.pi.waveAddNew();
                        this.pi.gpioWrite(Rf433tx.this.txGpio, true);
                        Thread.sleep(Rf433tx.this.protocol.TX_PULSE_MSGGAP / 1000);
                        this.pi.waveAddGeneric(this.wavePulses.remove(0));
                        n = this.pi.waveCreate();
                        for (int i = 0; i < Rf433tx.this.protocol.DGRM_REPEAT_TX && !this.stop; ++i) {
                            this.pi.waveSendOnce(n);
                            Thread.sleep(50L);
                            while (this.pi.waveTxBusy()) {
                                Thread.sleep(2L);
                            }
                        }
                        this.pi.waveDelete(n);
                        this.busy = false;
                        continue;
                    }
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (PigpioException pigpioException) {
                    this.error = true;
                    this.lastEx = pigpioException;
                    System.out.println("Error: while sending wave " + n);
                }
            }
        }

        void addWave(ArrayList<Pulse> arrayList) {
            this.wavePulses.add(arrayList);
        }

        boolean ready() throws PigpioException {
            return this.wavePulses.size() == 0 && !this.busy;
        }

        void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setName("WaveTransmitter");
                this.thread.start();
            }
        }

        void stop() throws PigpioException {
            this.stop = true;
            this.pi.waveTxStop();
        }
    }
}

