/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.sensors;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;

public class GY_271 {
    public static final int SAMPLES_1 = 0;
    public static final int SAMPLES_2 = 1;
    public static final int SAMPLES_4 = 2;
    public static final int SAMPLES_8 = 3;
    private static final int SAMPLE_MASK = 96;
    public static final int OUTPUT_RATE_0_75 = 0;
    public static final int OUTPUT_RATE_1_5 = 1;
    public static final int OUTPUT_RATE_3 = 2;
    public static final int OUTPUT_RATE_7_5 = 3;
    public static final int OUTPUT_RATE_15 = 4;
    public static final int OUTPUT_RATE_30 = 5;
    public static final int OUTPUT_RATE_75 = 6;
    private static final int OUTPUT_RATE_MASK = 28;
    public static final int GAIN_1370 = 0;
    public static final int GAIN_1090 = 1;
    public static final int GAIN_0820 = 2;
    public static final int GAIN_0660 = 3;
    public static final int GAIN_0440 = 4;
    public static final int GAIN_0390 = 5;
    public static final int GAIN_0330 = 6;
    public static final int GAIN_0230 = 7;
    private static final int GAIN_MASK = 224;
    public static final int MODE_CONTINUOUS = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_IDLE = 2;
    private static final int MODE_MASK = 3;
    private static final int REGISTER_CONFIG_A = 0;
    private static final int REGISTER_CONFIG_B = 1;
    private static final int REGISTER_MODE = 2;
    private static final int REGISTER_DATA_X_MSB = 3;
    private static final int REGISTER_DATA_X_LSB = 4;
    private static final int REGISTER_DATA_Z_MSB = 5;
    private static final int REGISTER_DATA_Z_LSB = 6;
    private static final int REGISTER_DATA_Y_MSB = 7;
    private static final int REGISTER_DATA_Y_LSB = 8;
    private static final int REGISTER_STATUS = 9;
    private static final int REGISTER_IDENT_A = 10;
    private static final int REGISTER_IDENT_B = 11;
    private static final int REGISTER_IDENT_C = 12;
    private final int GY_271_I2C_ADDRESS = 30;
    private final int PI_I2CBUS = 1;
    private int xValue = 0;
    private int yValue = 0;
    private int zValue = 0;
    private JPigpio pigpio;
    private int handle;

    public GY_271(JPigpio jPigpio) {
        this.pigpio = jPigpio;
    }

    public void initialize() throws PigpioException {
        this.handle = this.pigpio.i2cOpen(1, 30);
        this.setMode(0);
        this.setSamples(0);
        this.setOutputRate(15);
        this.setGain(1);
        this.pigpio.gpioDelay(500L);
    }

    public void close() throws PigpioException {
        this.pigpio.i2cClose(this.handle);
    }

    public void readValue() throws PigpioException {
        byte[] byArray = new byte[]{3};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
        this.pigpio.gpioDelay(100L, 1);
        byte[] byArray2 = new byte[6];
        this.pigpio.i2cReadDevice(this.handle, byArray2);
        this.xValue = byArray2[0] << 8 | byArray2[1];
        this.zValue = byArray2[2] << 8 | byArray2[3];
        this.yValue = byArray2[4] << 8 | byArray2[4];
    }

    public int getX() {
        return this.xValue;
    }

    public int getY() {
        return this.yValue;
    }

    public int getZ() {
        return this.zValue;
    }

    public String toString() {
        return String.format("x: %d, y: %d, z: %d", this.getX(), this.getY(), this.getZ());
    }

    public String getId() throws PigpioException {
        byte[] byArray = new byte[]{10};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
        byte[] byArray2 = new byte[3];
        this.pigpio.i2cReadDevice(this.handle, byArray2);
        return new String(byArray2);
    }

    public void setGain(int n) throws PigpioException {
        this.writeRegister(1, (byte)(this.readRegister(1) & 0xFFFFFF1F | n << 5));
    }

    public void setMode(int n) throws PigpioException {
        this.writeRegister(2, (byte)(this.readRegister(2) & 0xFFFFFFFC | n));
    }

    public void setSamples(int n) throws PigpioException {
        this.writeRegister(0, (byte)(this.readRegister(0) & 0xFFFFFF9F | n << 5));
    }

    public void setOutputRate(int n) throws PigpioException {
        this.writeRegister(0, (byte)(this.readRegister(0) & 0xFFFFFFE3 | n << 2));
    }

    public byte getStatus() throws PigpioException {
        return this.readRegister(9);
    }

    private byte readRegister(int n) throws PigpioException {
        byte[] byArray = new byte[]{(byte)n};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
        this.pigpio.i2cReadDevice(this.handle, byArray);
        return byArray[0];
    }

    private void writeRegister(int n, byte by) throws PigpioException {
        byte[] byArray = new byte[]{(byte)n, by};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
    }
}

