/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.sensors;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.WrongModeException;

public class HC_SR04 {
    private JPigpio pigpio;
    private int triggerGpio;
    private int echoGpio;

    public HC_SR04(JPigpio jPigpio, int n, int n2) throws PigpioException {
        this.pigpio = jPigpio;
        this.triggerGpio = n;
        this.echoGpio = n2;
        if (jPigpio.gpioGetMode(n) != 1) {
            throw new WrongModeException(n);
        }
        if (jPigpio.gpioGetMode(n2) != 0) {
            throw new WrongModeException(n2);
        }
    }

    public long getDelay() throws PigpioException {
        long l = this.pigpio.gpioxPulseAndWait(this.triggerGpio, this.echoGpio, 50000L, 10L, false);
        return l;
    }

    public double getMetricDistance() throws PigpioException {
        long l = this.getDelay();
        if (l == -1L) {
            return -1.0;
        }
        return (double)l / 1000000.0 * 340.39 / 2.0;
    }

    public double getImperialDistance() throws PigpioException {
        double d = this.getMetricDistance();
        if (d == -1.0) {
            return -1.0;
        }
        return d * 39.3701;
    }
}

