/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.sensors;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;
import eu.xeli.jpigpio.WrongModeException;
import eu.xeli.jpigpio.impl.SPI;

public class MFRC522 {
    private final byte STATUS_OK = 1;
    private final byte STATUS_ERROR = (byte)2;
    private final byte STATUS_COLLISION = (byte)3;
    private final byte STATUS_TIMEOUT = (byte)4;
    private final byte STATUS_NO_ROOM = (byte)5;
    private final byte STATUS_INTERNAL_ERROR = (byte)6;
    private final byte STATUS_INVALID = (byte)7;
    private final byte STATUS_CRC_WRONG = (byte)8;
    private final byte STATUS_MIFARE_NACK = (byte)9;
    private final byte CommandReg = (byte)2;
    private final byte ComIEnReg = (byte)4;
    private final byte DivIEnReg = (byte)6;
    private final byte ComIrqReg = (byte)8;
    private final byte DivIrqReg = (byte)10;
    private final byte ErrorReg = (byte)12;
    private final byte Status1Reg = (byte)14;
    private final byte Status2Reg = (byte)16;
    private final byte FIFODataReg = (byte)18;
    private final byte FIFOLevelReg = (byte)20;
    private final byte WaterLevelReg = (byte)22;
    private final byte ControlReg = (byte)24;
    private final byte BitFramingReg = (byte)26;
    private final byte CollReg = (byte)28;
    private final byte ModeReg = (byte)34;
    private final byte TxModeReg = (byte)36;
    private final byte RxModeReg = (byte)38;
    private final byte TxControlReg = (byte)40;
    private final byte TxASKReg = (byte)42;
    private final byte TxSelReg = (byte)44;
    private final byte RxSelReg = (byte)46;
    private final byte RxThresholdReg = (byte)48;
    private final byte DemodReg = (byte)50;
    private final byte MfTxReg = (byte)56;
    private final byte MfRxReg = (byte)58;
    private final byte SerialSpeedReg = (byte)62;
    private final byte CRCResultRegH = (byte)66;
    private final byte CRCResultRegL = (byte)68;
    private final byte ModWidthReg = (byte)72;
    private final byte RFCfgReg = (byte)76;
    private final byte GsNReg = (byte)78;
    private final byte CWGsPReg = (byte)80;
    private final byte ModGsPReg = (byte)82;
    private final byte TModeReg = (byte)84;
    private final byte TPrescalerReg = (byte)86;
    private final byte TReloadRegH = (byte)88;
    private final byte TReloadRegL = (byte)90;
    private final byte TCounterValueRegH = (byte)92;
    private final byte TCounterValueRegL = (byte)94;
    private final byte TestSel1Reg = (byte)98;
    private final byte TestSel2Reg = (byte)100;
    private final byte TestPinEnReg = (byte)102;
    private final byte TestPinValueReg = (byte)104;
    private final byte TestBusReg = (byte)106;
    private final byte AutoTestReg = (byte)108;
    private final byte VersionReg = (byte)110;
    private final byte AnalogTestReg = (byte)112;
    private final byte TestDAC1Reg = (byte)114;
    private final byte TestDAC2Reg = (byte)116;
    private final byte TestADCReg = (byte)118;
    private final byte PCD_Idle = 0;
    private final byte PCD_Mem = 1;
    private final byte PCD_GenerateRandomID = (byte)2;
    private final byte PCD_CalcCRC = (byte)3;
    private final byte PCD_Transmit = (byte)4;
    private final byte PCD_NoCmdChange = (byte)7;
    private final byte PCD_Receive = (byte)8;
    private final byte PCD_Transceive = (byte)12;
    private final byte PCD_MFAuthent = (byte)14;
    private final byte PCD_SoftReset = (byte)15;
    private JPigpio pigpio;
    private int chipSelectPin;
    private int resetPowerDownPin;
    private SPI spi;

    public MFRC522(JPigpio jPigpio, int n, int n2) throws PigpioException {
        this.pigpio = jPigpio;
        this.chipSelectPin = n;
        this.resetPowerDownPin = n2;
        if (jPigpio.gpioGetMode(n) != 1) {
            throw new WrongModeException(n);
        }
        if (jPigpio.gpioGetMode(n2) != 1) {
            throw new WrongModeException(n2);
        }
        jPigpio.gpioWrite(n, true);
        jPigpio.gpioWrite(n2, false);
        this.spi = new SPI(jPigpio, 0, 1000000, 0);
    }

    public void PCD_WriteRegister(byte by, byte by2) throws PigpioException {
        this.pigpio.gpioWrite(this.chipSelectPin, false);
        byte[] byArray = new byte[]{(byte)(by & 0x7E), by2};
        this.spi.write(byArray);
        this.pigpio.gpioWrite(this.chipSelectPin, true);
    }

    public void PCD_WriteRegister(byte by, byte[] byArray) throws PigpioException {
        this.pigpio.gpioWrite(this.chipSelectPin, false);
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)(by & 0x7E);
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.spi.write(byArray2);
        this.pigpio.gpioWrite(this.chipSelectPin, true);
    }

    public byte PCD_ReadRegister(byte by) throws PigpioException {
        this.pigpio.gpioWrite(this.chipSelectPin, false);
        this.spi.xfer((byte)(0x80 | by & 0x7E));
        byte by2 = this.spi.xfer((byte)0);
        this.pigpio.gpioWrite(this.chipSelectPin, true);
        return by2;
    }

    public void PCD_ReadRegister(byte by, byte[] byArray, byte by2) throws PigpioException {
        if (byArray.length == 0) {
            return;
        }
        byte by3 = (byte)(0x80 | by & 0x7E);
        this.pigpio.gpioWrite(this.chipSelectPin, false);
        this.spi.xfer(by3);
        for (int n = 0; n < byArray.length - 1; n = (int)((byte)(n + 1))) {
            if (n == 0 && by2 != 0) {
                byte by4;
                int n2 = 0;
                for (by4 = by2; by4 <= 7; by4 = (byte)(by4 + 1)) {
                    n2 = (byte)(n2 | 1 << by4);
                }
                by4 = this.spi.xfer(by3);
                byArray[0] = (byte)(byArray[n] & ~n2 | by4 & n2);
                continue;
            }
            byArray[n] = this.spi.xfer(by3);
        }
        byArray[n] = this.spi.xfer((byte)0);
        this.pigpio.gpioWrite(this.chipSelectPin, true);
    }

    public void PCD_SetRegisterBitMask(byte by, byte by2) throws PigpioException {
        byte by3 = this.PCD_ReadRegister(by);
        this.PCD_WriteRegister(by, (byte)(by3 | by2));
    }

    public void PCD_ClearRegisterBitMask(byte by, byte by2) throws PigpioException {
        byte by3 = this.PCD_ReadRegister(by);
        this.PCD_WriteRegister(by, (byte)(by3 & ~by2));
    }

    public byte PCD_CalculateCRC(byte[] byArray, byte by, byte[] byArray2) throws PigpioException {
        byte by2;
        this.PCD_WriteRegister((byte)2, (byte)0);
        this.PCD_WriteRegister((byte)10, (byte)4);
        this.PCD_SetRegisterBitMask((byte)20, (byte)-128);
        this.PCD_WriteRegister((byte)18, byArray);
        this.PCD_WriteRegister((byte)2, (byte)3);
        int n = 5000;
        while (((by2 = this.PCD_ReadRegister((byte)10)) & 4) == 0) {
            if (--n != 0) continue;
            return 4;
        }
        this.PCD_WriteRegister((byte)2, (byte)0);
        byArray2[0] = this.PCD_ReadRegister((byte)68);
        byArray2[1] = this.PCD_ReadRegister((byte)66);
        return 1;
    }

    public void PCD_Init() throws PigpioException {
        if (!this.pigpio.gpioRead(this.resetPowerDownPin)) {
            this.pigpio.gpioWrite(this.resetPowerDownPin, true);
            this.pigpio.gpioDelay(50L, 1);
        } else {
            this.PCD_Reset();
        }
        this.PCD_WriteRegister((byte)84, (byte)-128);
        this.PCD_WriteRegister((byte)86, (byte)-87);
        this.PCD_WriteRegister((byte)88, (byte)3);
        this.PCD_WriteRegister((byte)90, (byte)-24);
        this.PCD_WriteRegister((byte)42, (byte)64);
        this.PCD_WriteRegister((byte)34, (byte)61);
        this.PCD_AntennaOn();
    }

    public void PCD_Reset() throws PigpioException {
        this.PCD_WriteRegister((byte)2, (byte)15);
        this.pigpio.gpioDelay(50L, 1);
        while ((this.PCD_ReadRegister((byte)2) & 0x10) != 0) {
        }
    }

    public void PCD_AntennaOn() throws PigpioException {
        byte by = this.PCD_ReadRegister((byte)40);
        if ((by & 3) != 3) {
            this.PCD_WriteRegister((byte)40, (byte)(by | 3));
        }
    }

    public void PCD_AntennaOff() throws PigpioException {
        this.PCD_ClearRegisterBitMask((byte)40, (byte)3);
    }

    public byte PCD_GetAntennaGain() throws PigpioException {
        return (byte)(this.PCD_ReadRegister((byte)76) & 0x70);
    }

    public void PCD_SetAntennaGain(byte by) throws PigpioException {
        if (this.PCD_GetAntennaGain() != by) {
            this.PCD_ClearRegisterBitMask((byte)76, (byte)112);
            this.PCD_SetRegisterBitMask((byte)76, (byte)(by & 0x70));
        }
    }
}

