/*
 * Decompiled with CFR 0.152.
 */
package eu.xeli.jpigpio.sensors;

import eu.xeli.jpigpio.JPigpio;
import eu.xeli.jpigpio.PigpioException;

public class WiiNunchuck {
    private final int NUNCHUCK_DEVICE = 82;
    private final int PI_I2CBUS = 1;
    private JPigpio pigpio;
    private int handle;
    private byte joyX;
    private byte joyY;
    private byte accelX;
    private byte accelY;
    private byte accelZ;
    private boolean buttonC;
    private boolean buttonZ;

    public WiiNunchuck(JPigpio jPigpio) {
        this.pigpio = jPigpio;
    }

    public void initialize() throws PigpioException {
        this.handle = this.pigpio.i2cOpen(1, 82);
        byte[] byArray = new byte[]{64, 0};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
        this.pigpio.gpioDelay(500L);
    }

    public void close() throws PigpioException {
        this.pigpio.i2cClose(this.handle);
    }

    public void readValue() throws PigpioException {
        byte[] byArray = new byte[]{0};
        this.pigpio.i2cWriteDevice(this.handle, byArray);
        this.pigpio.gpioDelay(200L);
        byte[] byArray2 = new byte[6];
        this.pigpio.i2cReadDevice(this.handle, byArray2);
        byte[] byArray3 = byArray2;
        this.joyX = byArray3[0];
        this.joyY = byArray3[1];
        this.accelX = (byte)(byArray3[2] << 2 | (byArray3[5] & 0xC0) >> 6);
        this.accelY = (byte)(byArray3[3] << 2 | (byArray3[5] & 0x30) >> 4);
        this.accelZ = (byte)(byArray3[4] << 2 | (byArray3[5] & 0xC) >> 2);
        this.buttonC = (byArray3[5] & 2) >> 1 == 1;
        this.buttonZ = (byArray3[5] & 1) == 1;
    }

    public byte getJoyX() {
        return this.joyX;
    }

    public byte getJoyY() {
        return this.joyY;
    }

    public byte getAccelX() {
        return this.accelX;
    }

    public byte getAccelY() {
        return this.accelY;
    }

    public byte getAccelZ() {
        return this.accelZ;
    }

    public boolean isButtonC() {
        return this.buttonC;
    }

    public boolean isButtonZ() {
        return this.buttonZ;
    }

    public String toString() {
        return String.format("joyX=%d joyY=%d accelX=%d accelY=%d accelZ=%d buttonC=%b buttonZ=%b", Byte.toUnsignedInt(this.joyX), Byte.toUnsignedInt(this.joyY), Byte.toUnsignedInt(this.accelX), Byte.toUnsignedInt(this.accelY), Byte.toUnsignedInt(this.accelZ), this.buttonC, this.buttonZ);
    }
}

