/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.testing.integrationtesting.gradle;

import aQute.bnd.gradle.BundleTaskConvention;
import com.github.dynamicextensionsalfresco.gradle.configuration.BaseConfig;
import com.github.dynamicextensionsalfresco.gradle.tasks.DeBundleTaskConvention;
import com.github.dynamicextensionsalfresco.gradle.tasks.InstallBundle;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import eu.xenit.testing.integrationtesting.gradle.IntegrationTestSettings;
import eu.xenit.testing.integrationtesting.gradle.internal.IntegrationTestConfigurations;
import eu.xenit.testing.integrationtesting.gradle.internal.IntegrationTestTasks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugins.ide.idea.IdeaPlugin;

@NonNullApi
public class IntegrationTestPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        IntegrationTestSettings integrationTestSettings = this.createPluginSettings(project);
        project.getPlugins().withType(JavaPlugin.class, java -> {
            IntegrationTestConfigurations integrationTestConfigurations = IntegrationTestConfigurations.create(project);
            SourceSet integrationTestSourceSet = this.createIntegrationTestSourceSet(project);
            AbstractArchiveTask dynamicExtensionArchive = this.createDynamicExtensionsJarTask(project, integrationTestSourceSet, integrationTestConfigurations.getIntegrationTestImplementationRemote(), integrationTestSettings);
            IntegrationTestTasks integrationTestTasks = IntegrationTestTasks.create(project, integrationTestConfigurations, dynamicExtensionArchive, integrationTestSourceSet, integrationTestSettings.getRepository());
            InstallBundle installBundle = (InstallBundle)project.getTasks().withType(InstallBundle.class).findByName("installBundle");
            if (installBundle != null) {
                integrationTestTasks.getIntegrationTest().dependsOn(new Object[]{installBundle});
                integrationTestTasks.getInstallIntegrationTestsBundle().mustRunAfter(new Object[]{installBundle});
            }
            project.getTasks().getByName("check").dependsOn(new Object[]{integrationTestTasks.getIntegrationTest()});
            project.getPlugins().withType(IdeaPlugin.class, ideaPlugin -> ideaPlugin.getModel().module(ideaModule -> ideaModule.setTestSourceDirs(DefaultGroovyMethods.plus((Set)ideaModule.getTestResourceDirs(), (Collection)integrationTestSourceSet.getAllSource().getSrcDirs()))));
        });
    }

    private IntegrationTestSettings createPluginSettings(Project project) {
        IntegrationTestSettings integrationTestSettings = (IntegrationTestSettings)project.getExtensions().create("alfrescoIntegrationTest", IntegrationTestSettings.class, new Object[]{project.getObjects()});
        project.getPlugins().withId("eu.xenit.de", _plugin -> {
            BaseConfig deBaseConfig = (BaseConfig)project.getExtensions().findByType(BaseConfig.class);
            if (deBaseConfig != null) {
                integrationTestSettings.getRepository().convention((Object)deBaseConfig.getRepository());
            }
        });
        return integrationTestSettings;
    }

    private SourceSet createIntegrationTestSourceSet(Project project) {
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        SourceSet integrationTestsSourceSet = (SourceSet)sourceSets.maybeCreate("integrationTest");
        integrationTestsSourceSet.setCompileClasspath(mainSourceSet.getOutput().plus((FileCollection)project.getConfigurations().getByName(integrationTestsSourceSet.getCompileClasspathConfigurationName())));
        integrationTestsSourceSet.setRuntimeClasspath(integrationTestsSourceSet.getOutput().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)project.getConfigurations().getByName(integrationTestsSourceSet.getRuntimeClasspathConfigurationName())));
        return integrationTestsSourceSet;
    }

    private AbstractArchiveTask createDynamicExtensionsJarTask(Project project, SourceSet sourceSet, Configuration remoteDependencies, IntegrationTestSettings integrationTestSettings) {
        return (AbstractArchiveTask)project.getTasks().create("integrationTestFatJar", ShadowJar.class, task -> {
            task.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
            task.from(new Object[]{sourceSet.getOutput()});
            task.getArchiveClassifier().set((Object)"integration-test-all");
            task.setConfigurations(Collections.singletonList(remoteDependencies));
            DeBundleTaskConvention deBundleTaskConvention = new DeBundleTaskConvention((Jar)task);
            task.getConvention().getPlugins().put("de", deBundleTaskConvention);
            BundleTaskConvention bundleTaskConvention = (BundleTaskConvention)task.getConvention().getPlugin(BundleTaskConvention.class);
            bundleTaskConvention.setSourceSet(sourceSet);
            HashMap<String, String> manifest = new HashMap<String, String>();
            manifest.put("Bundle-Name", project.getName() + " Integration Tests");
            manifest.put("Bundle-SymbolicName", project.getName() + "-integration-test");
            task.doFirst(task1 -> {
                if (!"unspecified".equals(project.getVersion())) {
                    manifest.put("Bundle-Version", project.getVersion().toString());
                }
                manifest.put("Alfresco-Dynamic-Extension", "true");
                manifest.put("Require-Bundle", "eu.xenit.testing.integration-testing.alfresco-remote-testrunner");
                manifest.put("DynamicImport-Package", "*");
                manifest.put("Import-Package", "org.alfresco.*,eu.xenit.testing.integrationtesting.runner.*,org.junit;version=4.12,org.junit.runner;version=4.12,org.junit.runner.manipulation;version=4.12,org.junit.runners;version=4.12,org.junit.runners.model;version=4.12,org.junit.experimental.categories;version=4.12,org.junit.internal;version=4.12,org.junit.rules;version=4.12,org.junit.matchers;version=4.12,org.junit.runner.notification;version=4.12");
                manifest.put("Export-Package", String.join((CharSequence)",", (Iterable)integrationTestSettings.getIntegrationTestPackages().get()));
                bundleTaskConvention.bnd(manifest);
            });
        });
    }
}

