/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.testing.integrationtesting.gradle.internal;

import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public final class IntegrationTestConfigurations {
    private final Configuration integrationTestingBundle;
    private final Configuration integrationTestImplementationRemote;
    private final Configuration integrationTestImplementationLocal;

    private IntegrationTestConfigurations(Configuration integrationTestingBundle, Configuration integrationTestImplementationRemote, Configuration integrationTestImplementationLocal) {
        this.integrationTestingBundle = integrationTestingBundle;
        this.integrationTestImplementationRemote = integrationTestImplementationRemote;
        this.integrationTestImplementationLocal = integrationTestImplementationLocal;
    }

    public Configuration getIntegrationTestingBundle() {
        return this.integrationTestingBundle;
    }

    public Configuration getIntegrationTestImplementationRemote() {
        return this.integrationTestImplementationRemote;
    }

    public Configuration getIntegrationTestImplementationLocal() {
        return this.integrationTestImplementationLocal;
    }

    public static IntegrationTestConfigurations create(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        DependencyHandler dependencyHandler = project.getDependencies();
        Configuration integrationTestingBundle = IntegrationTestConfigurations.createIntegrationTestingBundle(configurations, dependencyHandler);
        Configuration integrationTestImplementationRemote = IntegrationTestConfigurations.createIntegrationTestImplementationRemote(configurations);
        Configuration integrationTestImplementationLocal = IntegrationTestConfigurations.createIntegrationTestImplementationLocal(configurations, dependencyHandler).extendsFrom(new Configuration[]{integrationTestingBundle, integrationTestImplementationRemote});
        project.getPluginManager().withPlugin("eu.xenit.alfresco", appliedPlugin -> integrationTestImplementationLocal.extendsFrom(new Configuration[]{configurations.getByName("alfrescoProvided")}));
        Configuration integrationTestImplementation = (Configuration)configurations.maybeCreate("integrationTestImplementation");
        integrationTestImplementation.extendsFrom(new Configuration[]{integrationTestImplementationLocal});
        return new IntegrationTestConfigurations(integrationTestingBundle, integrationTestImplementationRemote, integrationTestImplementationLocal);
    }

    private static Configuration createIntegrationTestImplementationLocal(ConfigurationContainer configurations, DependencyHandler dependencyHandler) {
        return (Configuration)configurations.create("integrationTestImplementationLocal", configuration -> configuration.defaultDependencies(dependencies -> dependencies.add((Object)dependencyHandler.create((Object)"commons-lang:commons-lang:1.0.0"))));
    }

    private static Configuration createIntegrationTestImplementationRemote(ConfigurationContainer configurations) {
        return (Configuration)configurations.create("integrationTestImplementationRemote");
    }

    private static Configuration createIntegrationTestingBundle(ConfigurationContainer configurations, DependencyHandler dependencyHandler) {
        return (Configuration)configurations.create("integrationTestBundle", configuration -> configuration.defaultDependencies(dependencies -> dependencies.add((Object)dependencyHandler.create((Object)"eu.xenit.testing.integration-testing:alfresco-remote-testrunner:2.0.1"))));
    }
}

