/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.testing.integrationtesting.gradle.internal;

import com.github.dynamicextensionsalfresco.gradle.configuration.Repository;
import com.github.dynamicextensionsalfresco.gradle.tasks.InstallBundle;
import eu.xenit.testing.integrationtesting.gradle.internal.IntegrationTestConfigurations;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.testing.Test;

public final class IntegrationTestTasks {
    private final InstallBundle installIntegrationTestingBundle;
    private final InstallBundle installIntegrationTestsBundle;
    private final Test integrationTest;

    private IntegrationTestTasks(InstallBundle installIntegrationTestingBundle, InstallBundle installIntegrationTestsBundle, Test integrationTest) {
        this.installIntegrationTestingBundle = installIntegrationTestingBundle;
        this.installIntegrationTestsBundle = installIntegrationTestsBundle;
        this.integrationTest = integrationTest;
    }

    public static IntegrationTestTasks create(Project project, IntegrationTestConfigurations integrationTestConfigurations, AbstractArchiveTask dynamicExtensionArchive, SourceSet integrationTestSourceSet, Provider<Repository> repositoryProvider) {
        InstallBundle installIntegrationTesting = IntegrationTestTasks.createInstallIntegrationTestingBundle(project, integrationTestConfigurations);
        InstallBundle installIntegrationTests = IntegrationTestTasks.createInstallIntegrationTestBundle(project, dynamicExtensionArchive);
        installIntegrationTests.dependsOn(new Object[]{installIntegrationTesting});
        Test integrationTest = IntegrationTestTasks.createIntegrationTest(project, integrationTestSourceSet, repositoryProvider);
        integrationTest.dependsOn(new Object[]{installIntegrationTests});
        return new IntegrationTestTasks(installIntegrationTesting, installIntegrationTests, integrationTest);
    }

    private static Test createIntegrationTest(Project project, SourceSet integrationTestSourceSet, Provider<Repository> repositoryProvider) {
        return (Test)project.getTasks().create("integrationTest", Test.class, task -> {
            task.setGroup("verification");
            task.setTestClassesDirs(integrationTestSourceSet.getOutput().getClassesDirs());
            task.setClasspath(integrationTestSourceSet.getRuntimeClasspath());
            task.doFirst(task1 -> {
                Repository repository = (Repository)repositoryProvider.getOrNull();
                if (repository != null) {
                    String urlBuilder = (String)repository.getEndpoint().getProtocol().get() + "://" + (String)repository.getAuthentication().getUsername().get() + ":" + (String)repository.getAuthentication().getPassword().get() + "@" + (String)repository.getEndpoint().getHost().get() + ":" + repository.getEndpoint().getPort().get() + (String)repository.getEndpoint().getServiceUrl().get();
                    task.systemProperty("eu.xenit.testing.integrationtesting.remote", (Object)urlBuilder);
                }
            });
        });
    }

    private static InstallBundle createInstallIntegrationTestBundle(Project project, AbstractArchiveTask dynamicExtensionArchive) {
        return (InstallBundle)project.getTasks().create("installIntegrationTestBundle", InstallBundle.class, task -> {
            task.dependsOn(new Object[]{dynamicExtensionArchive});
            task.setGroup("install");
            task.getFiles().from(new Object[]{dynamicExtensionArchive.getArchiveFile()});
        });
    }

    private static InstallBundle createInstallIntegrationTestingBundle(Project project, IntegrationTestConfigurations integrationTestConfigurations) {
        return (InstallBundle)project.getTasks().create("installIntegrationTestingBundle", InstallBundle.class, task -> {
            task.setGroup("install");
            task.setFiles(new Object[]{integrationTestConfigurations.getIntegrationTestingBundle()});
        });
    }

    public InstallBundle getInstallIntegrationTestingBundle() {
        return this.installIntegrationTestingBundle;
    }

    public InstallBundle getInstallIntegrationTestsBundle() {
        return this.installIntegrationTestsBundle;
    }

    public Test getIntegrationTest() {
        return this.integrationTest;
    }
}

