/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.alfresco.tomcat.embedded;

import eu.xenit.alfresco.tomcat.embedded.config.Configuration;
import eu.xenit.alfresco.tomcat.embedded.config.DefaultConfigurationProvider;
import eu.xenit.alfresco.tomcat.embedded.config.EnvironmentVariableConfigurationProvider;
import eu.xenit.alfresco.tomcat.embedded.tomcat.TomcatFactory;
import eu.xenit.json.jul.JsonFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.startup.Tomcat;

public class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        try {
            Configuration configuration = new DefaultConfigurationProvider().getConfiguration();
            configuration = new EnvironmentVariableConfigurationProvider().getConfiguration(configuration);
            Main.setSystemProperties(configuration);
            TomcatFactory tomcatFactory = new TomcatFactory(configuration);
            Tomcat tomcat = tomcatFactory.getTomcat();
            Main.configureLogging(configuration.isJsonLogging());
            tomcat.start();
            tomcat.getServer().await();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Main method failed", e);
            System.exit(1);
        }
    }

    private static void setSystemProperties(Configuration configuration) {
        configuration.getSystemProperties().forEach((key, value) -> {
            if (System.getProperty(key) == null) {
                System.setProperty(key, value);
            }
        });
    }

    private static void configureLogging(boolean json) {
        Main.configureLoggerToJSONStdOut(Logger.getLogger(""), "tomcat", json);
        Main.configureLoggerToJSONStdOut(LOG.getParent(), "tomcat", json);
        for (Handler handler : LOG.getHandlers()) {
            LOG.removeHandler(handler);
        }
    }

    private static void configureLoggerToJSONStdOut(Logger logger, String component, boolean json) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        ConsoleHandler customHandler = new ConsoleHandler(){
            {
                this.setOutputStream(System.out);
            }
        };
        if (json) {
            JsonFormatter formatter = new JsonFormatter();
            formatter.setType("application");
            formatter.setComponent(component);
            formatter.setExtractStackTrace("true");
            formatter.setFilterStackTrace(true);
            customHandler.setFormatter((Formatter)formatter);
        }
        logger.addHandler(customHandler);
    }
}

