/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.alfresco.tomcat.embedded.config;

import eu.xenit.alfresco.tomcat.embedded.config.Configuration;
import eu.xenit.alfresco.tomcat.embedded.config.ConfigurationProvider;
import java.util.function.Consumer;

public class EnvironmentVariableConfigurationProvider
implements ConfigurationProvider {
    public static final String TOMCAT_WEBAPPS = "TOMCAT_WEBAPPS";
    public static final String JSON_LOGGING = "JSON_LOGGING";
    public static final String ACCESS_LOGGING = "ACCESS_LOGGING";
    private static final String LOGLIBRARY_DIR = "LOGLIBRARY_DIR";
    private static final String ALFRESCO_VERSION = "ALFRESCO_VERSION";
    private static final String ALFRESCO_FLAVOUR = "ALFRESCO_FLAVOUR";
    private static final String DB_HOST = "DB_HOST";
    private static final String DB_PORT = "DB_PORT";
    private static final String DB_NAME = "DB_NAME";
    private static final String DB_DRIVER = "DB_DRIVER";
    private static final String DB_USERNAME = "DB_USERNAME";
    private static final String DB_PASSWORD = "DB_PASSWORD";
    private static final String DB_URL = "DB_URL";
    private static final String DB_QUERY = "DB_QUERY";
    private static final String INDEX = "INDEX";
    private static final String SOLR_SSL = "SOLR_SSL";
    private static final String SOLR_HOST = "SOLR_HOST";
    private static final String SOLR_PORT = "SOLR_PORT";
    private static final String SOLR_PORT_SSL = "SOLR_PORT_SSL";
    private static final String TOMCAT_SSL_KEYSTORE = "TOMCAT_SSL_KEYSTORE";
    private static final String TOMCAT_SSL_KEYSTORE_KEY_META_DATA_LOCATION = "TOMCAT_SSL_KEYSTORE_KEY_META_DATA_LOCATION";
    private static final String TOMCAT_SSL_KEYSTORE_PASSWORD = "TOMCAT_SSL_KEYSTORE_PASSWORD";
    private static final String TOMCAT_SSL_TRUSTSTORE = "TOMCAT_SSL_TRUSTSTORE";
    private static final String TOMCAT_SSL_TRUSTSTORE_KEY_META_DATA_LOCATION = "TOMCAT_SSL_TRUSTSTORE_KEY_META_DATA_LOCATION";
    private static final String TOMCAT_SSL_TRUSTSTORE_PASSWORD = "TOMCAT_SSL_TRUSTSTORE_PASSWORD";
    private static final String TOMCAT_PORT = "TOMCAT_PORT";
    private static final String TOMCAT_PORT_SSL = "TOMCAT_PORT_SSL";
    private static final String TOMCAT_SERVER_PORT = "TOMCAT_SERVER_PORT";
    private static final String TOMCAT_MAX_HTTP_HEADER_SIZE = "TOMCAT_MAX_HTTP_HEADER_SIZE";
    private static final String TOMCAT_MAX_THREADS = "TOMCAT_MAX_THREADS";
    private static final String TOMCAT_RELAXED_QUERY_CHARS = "TOMCAT_RELAXED_QUERY_CHARS";
    private static final String TOMCAT_RELAXED_PATH_CHARS = "TOMCAT_RELAXED_PATH_CHARS";
    private static final String ENABLE_CLUSTERING = "ENABLE_CLUSTERING";
    private static final String EXIT_ON_FAILURE = "EXIT_ON_FAILURE";
    private static final String DIR_ROOT = "DIR_ROOT";

    @Override
    public Configuration getConfiguration(Configuration baseConfiguration) {
        this.setPropertyFromEnv(TOMCAT_WEBAPPS, baseConfiguration::setWebappsPath);
        this.setPropertyFromEnv(JSON_LOGGING, value -> baseConfiguration.setJsonLogging(Boolean.parseBoolean(value)));
        this.setPropertyFromEnv(ACCESS_LOGGING, value -> baseConfiguration.setAccessLogging(Boolean.parseBoolean(value)));
        this.setPropertyFromEnv(LOGLIBRARY_DIR, baseConfiguration::setLogLibraryDir);
        this.setPropertyFromEnv(ALFRESCO_VERSION, baseConfiguration::setAlfrescoVersion);
        this.setPropertyFromEnv(ALFRESCO_FLAVOUR, baseConfiguration::setAlfrescoFlavour);
        this.setGlobalPropertyFromEnv(DB_HOST, baseConfiguration, "db.host");
        this.setGlobalPropertyFromEnv(DB_NAME, baseConfiguration, "db.NAME");
        this.setGlobalPropertyFromEnv(DB_PORT, baseConfiguration, "db.port");
        this.setGlobalPropertyFromEnv(DB_DRIVER, baseConfiguration, "db.driver");
        this.setGlobalPropertyFromEnv(DB_USERNAME, baseConfiguration, "db.username");
        this.setGlobalPropertyFromEnv(DB_PASSWORD, baseConfiguration, "db.password");
        this.setGlobalPropertyFromEnv(DB_URL, baseConfiguration, "db.url");
        this.setGlobalPropertyFromEnv(DB_QUERY, baseConfiguration, "db.query");
        this.setGlobalPropertyFromEnv(SOLR_HOST, baseConfiguration, "solr.host");
        this.setGlobalPropertyFromEnv(SOLR_PORT, baseConfiguration, "solr.port");
        this.setGlobalPropertyFromEnv(SOLR_PORT_SSL, baseConfiguration, "solr.port.ssl");
        if ("none".equals(System.getenv(SOLR_SSL))) {
            baseConfiguration.setSolrSSLEnabled(false);
        }
        this.setGlobalPropertyFromEnv(SOLR_SSL, baseConfiguration, "solr.secureComms");
        this.setPropertyFromEnv(TOMCAT_SSL_KEYSTORE, baseConfiguration::setTomcatSSLKeystore);
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_KEYSTORE, baseConfiguration, "encryption.ssl.keystore.location");
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_KEYSTORE_KEY_META_DATA_LOCATION, baseConfiguration, "encryption.ssl.keystore.keyMetaData.location");
        this.setPropertyFromEnv(TOMCAT_SSL_KEYSTORE_PASSWORD, baseConfiguration::setTomcatSSLKeystorePassword);
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_KEYSTORE_PASSWORD, baseConfiguration, "ssl-keystore.password");
        this.setPropertyFromEnv(TOMCAT_SSL_TRUSTSTORE, baseConfiguration::setTomcatSSLTruststore);
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_TRUSTSTORE, baseConfiguration, "encryption.ssl.truststore.location");
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_TRUSTSTORE_KEY_META_DATA_LOCATION, baseConfiguration, "encryption.ssl.truststore.keyMetaData.location");
        this.setPropertyFromEnv(TOMCAT_SSL_TRUSTSTORE_PASSWORD, baseConfiguration::setTomcatSSLTruststorePassword);
        this.setGlobalPropertyFromEnv(TOMCAT_SSL_TRUSTSTORE_PASSWORD, baseConfiguration, "ssl-truststore.password");
        this.setGlobalPropertyFromEnv(ENABLE_CLUSTERING, baseConfiguration, "alfresco.cluster.enabled");
        this.setPropertyFromEnv(TOMCAT_PORT, value -> baseConfiguration.setPort(Integer.parseInt(value)));
        this.setPropertyFromEnv(TOMCAT_PORT_SSL, value -> baseConfiguration.setTomcatSslPort(Integer.parseInt(value)));
        this.setPropertyFromEnv(TOMCAT_SERVER_PORT, value -> baseConfiguration.setTomcatServerPort(Integer.parseInt(value)));
        this.setPropertyFromEnv(TOMCAT_MAX_HTTP_HEADER_SIZE, value -> baseConfiguration.setTomcatMaxHttpHeaderSize(Integer.parseInt(value)));
        this.setPropertyFromEnv(TOMCAT_MAX_THREADS, value -> baseConfiguration.setTomcatMaxThreads(Integer.parseInt(value)));
        this.setPropertyFromEnv(TOMCAT_RELAXED_QUERY_CHARS, baseConfiguration::setTomcatRelaxedQueryChars);
        this.setPropertyFromEnv(TOMCAT_RELAXED_PATH_CHARS, baseConfiguration::setTomcatRelaxedPathChars);
        this.setGlobalPropertyFromEnv(INDEX, baseConfiguration, "index.subsystem.name");
        this.setGlobalPropertyFromEnv(DIR_ROOT, baseConfiguration, "dir.root");
        this.setPropertyFromEnv(EXIT_ON_FAILURE, value -> baseConfiguration.setExitOnFailure(Boolean.parseBoolean(value)));
        this.setGlobalProperties(baseConfiguration);
        return baseConfiguration;
    }

    private void setGlobalProperties(Configuration baseConfiguration) {
        System.getenv().forEach((key, value) -> {
            if (key.startsWith("GLOBAL_")) {
                String prop = key.substring(7);
                baseConfiguration.setGlobalProperty(prop, (String)value);
            }
        });
    }

    private void setPropertyFromEnv(String env, Consumer<String> stringConsumer) {
        if (System.getenv(env) != null) {
            stringConsumer.accept(System.getenv(env));
        }
    }

    private void setGlobalPropertyFromEnv(String env, Configuration configuration, String property) {
        this.setPropertyFromEnv(env, value -> configuration.setGlobalProperty(property, (String)value));
    }
}

