/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.alfresco.tomcat.embedded.tomcat;

import eu.xenit.alfresco.tomcat.embedded.config.Configuration;
import eu.xenit.json.valve.JsonAccessLogValve;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.net.SSLHostConfig;

public class TomcatFactory {
    private static final Logger LOG = Logger.getLogger(TomcatFactory.class.getName());
    private Configuration configuration;

    public TomcatFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public Tomcat getTomcat() throws IOException {
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(this.configuration.getPort());
        tomcat.getServer().setPort(this.configuration.getTomcatServerPort());
        this.createDefaultConnector(tomcat);
        if (this.configuration.isSolrSSLEnabled()) {
            this.createSSLConnector(tomcat);
        }
        this.addUserWithRole(tomcat, "CN=Alfresco Repository Client, OU=Unknown, O=Alfresco Software Ltd., L=Maidenhead, ST=UK, C=GB", null, "repoclient");
        this.addUserWithRole(tomcat, "CN=Alfresco Repository, OU=Unknown, O=Alfresco Software Ltd., L=Maidenhead, ST=UK, C=GB", null, "repository");
        Path webapps = Paths.get(this.configuration.getWebappsPath(), new String[0]);
        if (Files.exists(webapps, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(webapps);){
                directoryStream.forEach(path -> this.addWebapp(tomcat, (Path)path));
            }
        }
        return tomcat;
    }

    private boolean isEmptyDir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> entries = Files.list(path);
                try {
                    bl = entries.findFirst().isEmpty();
                    if (entries == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (entries != null) {
                            try {
                                entries.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                entries.close();
            }
            return bl;
        }
        return false;
    }

    private void addWebapp(Tomcat tomcat, Path path) {
        if (this.isEmptyDir(path)) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            String contextPath = "/" + path.getFileName().toString();
            String absolutePath = path.toAbsolutePath().toString();
            StandardContext ctx = (StandardContext)tomcat.addWebapp(contextPath, absolutePath);
            ctx.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            LifecycleListener lifecycleListener = event -> {
                if (event.getType().equals("before_start")) {
                    StandardRoot resources = new StandardRoot((Context)ctx);
                    Path globalPropertiesFile = this.getGlobalPropertiesFile();
                    resources.addPostResources((WebResourceSet)new DirResourceSet((WebResourceRoot)resources, "/WEB-INF/classes", globalPropertiesFile.toAbsolutePath().getParent().toString(), "/"));
                    if (this.configuration.isJsonLogging() && this.redirectLog4j(path)) {
                        resources.addJarResources((WebResourceSet)new DirResourceSet((WebResourceRoot)resources, "/WEB-INF/lib", this.configuration.getLogLibraryDir(), "/"));
                    }
                    ctx.setResources((WebResourceRoot)resources);
                }
                if (this.configuration.isExitOnFailure() && event.getType().equals("after_stop")) {
                    this.stopTomcat(tomcat);
                }
            };
            ctx.addLifecycleListener(lifecycleListener);
            if (this.configuration.isAccessLogging()) {
                JsonAccessLogValve valve = new JsonAccessLogValve();
                ctx.addValve((Valve)valve);
                ctx.getAccessLog();
            }
        }
    }

    private Path getGlobalPropertiesFile() {
        Properties globalProperties = new Properties();
        globalProperties.putAll(this.configuration.getGlobalProperties());
        Path classesDir = Paths.get("/dev", "shm", "alfrescoClasses");
        try {
            Files.createDirectories(classesDir, new FileAttribute[0]);
            Path tempProps = Paths.get("/dev", "shm", "alfrescoClasses", "alfresco-global.properties");
            if (Files.exists(tempProps, new LinkOption[0])) {
                Files.delete(tempProps);
            }
            tempProps = Files.createFile(tempProps, new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempProps, new OpenOption[0]);){
                globalProperties.store(os, null);
            }
            return tempProps;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createDefaultConnector(Tomcat tomcat) {
        Connector connector = this.getConnector(tomcat, "HTTP/1.1", this.configuration.getPort(), false, "http");
        connector.setRedirectPort(this.configuration.getTomcatSslPort());
        tomcat.setConnector(connector);
    }

    private void createSSLConnector(Tomcat tomcat) {
        if (!new File(this.configuration.getTomcatSSLKeystore()).exists()) {
            LOG.severe("Keystore file missing: " + this.configuration.getTomcatSSLKeystore());
            System.exit(1);
        }
        if (!new File(this.configuration.getTomcatSSLTruststore()).exists()) {
            LOG.severe("Truststore file missing: " + this.configuration.getTomcatSSLTruststore());
            System.exit(1);
        }
        Connector connector = this.getConnector(tomcat, "org.apache.coyote.http11.Http11NioProtocol", this.configuration.getTomcatSslPort(), true, "https");
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        sslHostConfig.setCertificateKeystoreFile(this.configuration.getTomcatSSLKeystore());
        sslHostConfig.setCertificateKeystorePassword(this.configuration.getTomcatSSLKeystorePassword());
        sslHostConfig.setCertificateKeystoreType("JCEKS");
        sslHostConfig.setTruststoreFile(this.configuration.getTomcatSSLTruststore());
        sslHostConfig.setTruststorePassword(this.configuration.getTomcatSSLTruststorePassword());
        sslHostConfig.setTruststoreType("JCEKS");
        sslHostConfig.setSslProtocol("TLS");
        sslHostConfig.setCertificateVerification(SSLHostConfig.CertificateVerification.REQUIRED.name());
        connector.addSslHostConfig(sslHostConfig);
        connector.setSecure(true);
        connector.setProperty("clientAuth", "want");
        connector.setProperty("allowUnsafeLegacyRenegotiation", "true");
        connector.setMaxSavePostSize(-1);
        tomcat.setConnector(connector);
    }

    private Connector getConnector(Tomcat tomcat, String protocol, int port, boolean sslEnabled, String scheme) {
        Connector connector = new Connector(protocol);
        connector.setPort(port);
        connector.setProperty("connectionTimeout", "240000");
        connector.setURIEncoding(StandardCharsets.UTF_8.name());
        connector.setProperty("SSLEnabled", String.valueOf(sslEnabled));
        connector.setProperty("maxThreads", String.valueOf(this.configuration.getTomcatMaxThreads()));
        connector.setProperty("maxHttpHeaderSize", String.valueOf(this.configuration.getTomcatMaxHttpHeaderSize()));
        connector.setScheme(scheme);
        Service service = tomcat.getService();
        service.setContainer(tomcat.getEngine());
        connector.setService(service);
        return connector;
    }

    private void addUserWithRole(Tomcat tomcat, String username, String password, String role) {
        tomcat.addUser(username, password);
        tomcat.addRole(username, role);
    }

    private boolean redirectLog4j(Path path) {
        Path log4JPropertiesPath = path.resolve("WEB-INF/classes/log4j.properties");
        if (!Files.exists(log4JPropertiesPath, new LinkOption[0])) {
            LOG.warning("Log4j file doesn't exist under path " + log4JPropertiesPath);
            return false;
        }
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(log4JPropertiesPath);){
            properties.load(reader);
            properties.setProperty("log4j.rootLogger", "error, Console, jmxlogger1");
            properties.setProperty("log4j.appender.Console.layout", "eu.xenit.json.log4j.JsonLayout");
            properties.setProperty("log4j.appender.Console.layout.Type", "application");
            properties.setProperty("log4j.appender.Console.layout.Component", path.getFileName().toString());
            properties.setProperty("log4j.appender.Console.layout.ExtractStackTrace", "true");
            properties.setProperty("log4j.appender.Console.layout.FilterStackTrace", "true");
            Path tempProps = Files.createTempFile("log4j-", ".properties", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempProps, new OpenOption[0]);){
                properties.store(os, null);
            }
            System.setProperty("log4j.configuration", "file:" + tempProps.toAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void stopTomcat(Tomcat tomcat) {
        Thread thread = new Thread(() -> {
            try {
                tomcat.stop();
                tomcat.destroy();
            }
            catch (LifecycleException e) {
                e.printStackTrace();
            }
        });
        thread.start();
    }
}

