/*
 * Decompiled with CFR 0.152.
 */
package eu.zirrus.gcloud.logging.log4j;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="CloudLogging", category="Core", elementType="appender", printObject=true)
public class CloudLoggingAppender
extends AbstractAppender {
    protected String logName = "default";
    protected MonitoredResource resource;
    protected boolean ignoreExceptions = false;
    protected Logging logging;

    public CloudLoggingAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        this(name, filter, layout, true, null, null);
    }

    public CloudLoggingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        this(name, filter, layout, ignoreExceptions, null, null);
    }

    public CloudLoggingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String projectId, String credentialsFile) {
        super(name, filter, layout, ignoreExceptions);
        this.logName = name;
        this.ignoreExceptions = ignoreExceptions;
        LoggingOptions.Builder builder = LoggingOptions.newBuilder();
        if (projectId != null) {
            builder.setProjectId(projectId);
        }
        if (credentialsFile != null) {
            try {
                GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(credentialsFile));
                builder.setCredentials((Credentials)credentials);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LoggingOptions loggingOptions = builder.build();
        this.logging = (Logging)loggingOptions.getService();
        this.resource = MonitoredResource.newBuilder((String)"global").build();
    }

    public void append(LogEvent event) {
        String text = event.getMessage().getFormattedMessage();
        LogEntry entry = LogEntry.newBuilder((Payload)Payload.StringPayload.of((String)text)).setLogName(this.logName).setResource(this.resource).setSeverity(CloudLoggingAppender.getCloudLoggingSeverity(event.getLevel())).build();
        this.logging.write(Collections.singleton(entry), new Logging.WriteOption[0]);
    }

    public static Severity getCloudLoggingSeverity(Level level) {
        switch (level.intLevel()) {
            case 100: {
                return Severity.CRITICAL;
            }
            case 200: {
                return Severity.ERROR;
            }
            case 300: {
                return Severity.WARNING;
            }
            case 400: {
                return Severity.INFO;
            }
            case 500: 
            case 600: {
                return Severity.DEBUG;
            }
        }
        return Severity.INFO;
    }

    @PluginFactory
    public static CloudLoggingAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="projectId") String projectId, @PluginAttribute(value="credentialsFile") String credentialsFile) {
        if (name == null) {
            name = "default";
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new CloudLoggingAppender(name, filter, (Layout<? extends Serializable>)layout, true, projectId, credentialsFile);
    }
}

