/*
 * Decompiled with CFR 0.152.
 */
package base.boudicca.format;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lbase/boudicca/format/DateFormat;", "", "<init>", "()V", "parseFromString", "Ljava/time/OffsetDateTime;", "value", "", "parseToString", "date", "common-model"})
public final class DateFormat {
    @NotNull
    public static final DateFormat INSTANCE = new DateFormat();

    private DateFormat() {
    }

    @NotNull
    public final OffsetDateTime parseFromString(@NotNull String value) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"parse(...)");
            return offsetDateTime;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("could not parse string value " + value + " into date", e);
        }
    }

    @NotNull
    public final String parseToString(@NotNull OffsetDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateTimeFormatter.ISO_DATE_TIME.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

