/*
 * Decompiled with CFR 0.152.
 */
package base.boudicca.keyfilters;

import base.boudicca.model.structured.Key;
import base.boudicca.model.structured.StructuredEvent;
import base.boudicca.model.structured.Variant;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ8\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\u00072\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\rj\u0002`\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\bH\u0002J$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a8\u0006\u0019"}, d2={"Lbase/boudicca/keyfilters/KeyFilters;", "", "<init>", "()V", "filterKeys", "", "Lkotlin/Pair;", "Lbase/boudicca/model/structured/Key;", "", "keyFilter", "event", "Lbase/boudicca/model/structured/StructuredEvent;", "data", "", "Lbase/boudicca/model/structured/StructuredEntry;", "doesKeyMatchFilter", "", "key", "containsVariant", "variant", "Lbase/boudicca/model/structured/Variant;", "doesContainVariantName", "variantName", "doesContainVariantValue", "variantValues", "common-model"})
@SourceDebugExtension(value={"SMAP\nKeyFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyFilters.kt\nbase/boudicca/keyfilters/KeyFilters\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n535#2:79\n520#2,6:80\n1053#3:86\n*S KotlinDebug\n*F\n+ 1 KeyFilters.kt\nbase/boudicca/keyfilters/KeyFilters\n*L\n21#1:79\n21#1:80,6\n23#1:86\n*E\n"})
public final class KeyFilters {
    @NotNull
    public static final KeyFilters INSTANCE = new KeyFilters();

    private KeyFilters() {
    }

    @NotNull
    public final List<Pair<Key, String>> filterKeys(@NotNull Key keyFilter, @NotNull StructuredEvent event) {
        Intrinsics.checkNotNullParameter((Object)keyFilter, (String)"keyFilter");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.filterKeys(keyFilter, event.toEntry());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Key, String>> filterKeys(@NotNull Key keyFilter, @NotNull Map<Key, String> data) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keyFilter, (String)"keyFilter");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Map<Key, String> $this$filter$iv = data;
        boolean $i$f$filter = false;
        Map<Key, String> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!INSTANCE.doesKeyMatchFilter((Key)it.getKey(), keyFilter)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$sortedBy$iv = MapsKt.toList((Map)destination$iv$iv);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Key)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Key)it.getFirst()));
            }
        });
    }

    public final boolean doesKeyMatchFilter(@NotNull Key key, @NotNull Key keyFilter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)keyFilter, (String)"keyFilter");
        if (!Intrinsics.areEqual((Object)keyFilter.getName(), (Object)"*") && !Intrinsics.areEqual((Object)keyFilter.getName(), (Object)key.getName())) {
            return false;
        }
        for (Variant variant : keyFilter.getVariants()) {
            if (this.containsVariant(key, variant)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsVariant(@NotNull Key key, @NotNull Variant variant) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (Intrinsics.areEqual((Object)variant.getVariantValue(), (Object)"*")) {
            return this.doesContainVariantName(key, variant.getVariantName());
        }
        if (Intrinsics.areEqual((Object)variant.getVariantValue(), (Object)"")) {
            return !this.doesContainVariantName(key, variant.getVariantName());
        }
        for (Variant selfVariant : key.getVariants()) {
            if (!Intrinsics.areEqual((Object)variant.getVariantName(), (Object)selfVariant.getVariantName()) || !Intrinsics.areEqual((Object)variant.getVariantValue(), (Object)selfVariant.getVariantValue())) continue;
            return true;
        }
        return false;
    }

    private final boolean doesContainVariantName(Key key, String variantName) {
        for (Variant variant : key.getVariants()) {
            if (!Intrinsics.areEqual((Object)variantName, (Object)variant.getVariantName())) continue;
            return true;
        }
        return false;
    }

    public final boolean doesContainVariantValue(@NotNull Key key, @NotNull String variantName, @NotNull List<String> variantValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter(variantValues, (String)"variantValues");
        for (String value : variantValues) {
            if (!this.containsVariant(key, new Variant(variantName, value))) continue;
            return true;
        }
        return false;
    }
}

