/*
 * Decompiled with CFR 0.152.
 */
package base.boudicca.keyfilters;

import base.boudicca.keyfilters.KeyFilters;
import base.boudicca.model.EntryKt;
import base.boudicca.model.Event;
import base.boudicca.model.structured.Key;
import base.boudicca.model.structured.StructuredEvent;
import base.boudicca.model.structured.Variant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\u00060\n2\u0006\u0010\f\u001a\u00020\rJ0\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\u00060\n2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\u000fj\u0002`\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lbase/boudicca/keyfilters/KeySelector;", "", "propertyName", "", "variants", "", "Lkotlin/Pair;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "selectSingle", "Ljava/util/Optional;", "Lbase/boudicca/model/structured/Key;", "event", "Lbase/boudicca/model/structured/StructuredEvent;", "properties", "", "Lbase/boudicca/model/structured/StructuredEntry;", "Companion", "KeySelectorBuilder", "common-model"})
public final class KeySelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String propertyName;
    @NotNull
    private final List<Pair<String, List<String>>> variants;

    private KeySelector(String propertyName, List<? extends Pair<String, ? extends List<String>>> variants) {
        this.propertyName = propertyName;
        this.variants = variants;
    }

    @NotNull
    public final Optional<Pair<Key, String>> selectSingle(@NotNull StructuredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.selectSingle(EntryKt.toStructuredEntry(Event.Companion.toEntry(event.toFlatEvent())));
    }

    @NotNull
    public final Optional<Pair<Key, String>> selectSingle(@NotNull Map<Key, String> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        List variantList = new ArrayList();
        int n = 0;
        int n2 = this.variants.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = 0;
        }
        int[] variantIndexes = nArray;
        int currentVariant = 0;
        while (true) {
            if (currentVariant < 0) {
                Optional<Pair<Key, String>> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            if (currentVariant >= this.variants.size()) {
                Key keyFilter = Key.Companion.builder(this.propertyName).withVariants(variantList).build();
                List<Pair<Key, String>> keys = KeyFilters.INSTANCE.filterKeys(keyFilter, properties);
                if (!((Collection)keys).isEmpty()) {
                    Optional<Object> optional = Optional.of(CollectionsKt.first(keys));
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
                --currentVariant;
                if (!(!((Collection)variantList).isEmpty())) continue;
                variantList.removeLast();
                continue;
            }
            int currentVariantPlace = variantIndexes[currentVariant];
            if (currentVariantPlace >= ((List)this.variants.get(currentVariant).getSecond()).size()) {
                variantIndexes[currentVariant] = 0;
                --currentVariant;
                if (!(!((Collection)variantList).isEmpty())) continue;
                variantList.removeLast();
                continue;
            }
            variantList.add(new Variant((String)this.variants.get(currentVariant).getFirst(), (String)((List)this.variants.get(currentVariant).getSecond()).get(currentVariantPlace)));
            variantIndexes[currentVariant] = variantIndexes[currentVariant] + 1;
            ++currentVariant;
        }
    }

    public /* synthetic */ KeySelector(String propertyName, List variants, DefaultConstructorMarker $constructor_marker) {
        this(propertyName, variants);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lbase/boudicca/keyfilters/KeySelector$Companion;", "", "<init>", "()V", "builder", "Lbase/boudicca/keyfilters/KeySelector$KeySelectorBuilder;", "propertyName", "", "key", "Lbase/boudicca/model/structured/Key;", "common-model"})
    @SourceDebugExtension(value={"SMAP\nKeySelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeySelector.kt\nbase/boudicca/keyfilters/KeySelector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1863#2,2:130\n*S KotlinDebug\n*F\n+ 1 KeySelector.kt\nbase/boudicca/keyfilters/KeySelector$Companion\n*L\n105#1:130,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeySelectorBuilder builder(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            return new KeySelectorBuilder(propertyName);
        }

        @NotNull
        public final KeySelectorBuilder builder(@NotNull Key key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            KeySelectorBuilder builder = new KeySelectorBuilder(key.getName());
            Iterable $this$forEach$iv = key.getVariants();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Variant it = (Variant)element$iv;
                boolean bl = false;
                builder.thenVariant(it);
            }
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lbase/boudicca/keyfilters/KeySelector$KeySelectorBuilder;", "", "propertyName", "", "<init>", "(Ljava/lang/String;)V", "variants", "", "Lkotlin/Pair;", "", "thenVariant", "variantName", "variantValues", "variant", "Lbase/boudicca/model/structured/Variant;", "build", "Lbase/boudicca/keyfilters/KeySelector;", "common-model"})
    public static final class KeySelectorBuilder {
        @NotNull
        private final String propertyName;
        @NotNull
        private final List<Pair<String, List<String>>> variants;

        public KeySelectorBuilder(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.propertyName = propertyName;
            this.variants = new ArrayList();
        }

        @NotNull
        public final KeySelectorBuilder thenVariant(@NotNull String variantName, @NotNull List<String> variantValues) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter(variantValues, (String)"variantValues");
            this.variants.add((Pair<String, List<String>>)new Pair((Object)variantName, variantValues));
            return this;
        }

        @NotNull
        public final KeySelectorBuilder thenVariant(@NotNull Variant variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this.variants.add((Pair<String, List<String>>)new Pair((Object)variant.getVariantName(), (Object)CollectionsKt.listOf((Object)variant.getVariantValue())));
            return this;
        }

        @NotNull
        public final KeySelector build() {
            return new KeySelector(this.propertyName, CollectionsKt.toList((Iterable)this.variants), null);
        }
    }
}

