/*
 * Decompiled with CFR 0.152.
 */
package base.boudicca.model.structured;

import base.boudicca.model.structured.KeyUtils;
import base.boudicca.model.structured.Variant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0019\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u0003J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lbase/boudicca/model/structured/Key;", "", "name", "", "variants", "", "Lbase/boudicca/model/structured/Variant;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getVariants", "()Ljava/util/List;", "toKeyString", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "Companion", "KeyBuilder", "common-model"})
public final class Key
implements Comparable<Key> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Variant> variants;
    private static final Comparator<Key> COMPARATOR = ((Comparator)new Comparator(){

        public final int compare(T a, T b) {
            Key it = (Key)a;
            boolean bl = false;
            Comparable comparable = (Comparable)((Object)it.getName());
            it = (Key)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
        }
    }).thenComparing((arg_0, arg_1) -> Key.COMPARATOR$lambda$3(Key::COMPARATOR$lambda$2, arg_0, arg_1));

    public Key(@NotNull String name, @NotNull List<Variant> variants) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        this.name = name;
        this.variants = variants;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Variant> getVariants() {
        return this.variants;
    }

    @NotNull
    public final String toKeyString() {
        if (this.variants.isEmpty()) {
            return this.name;
        }
        return this.name + ":" + CollectionsKt.joinToString$default((Iterable)this.variants, (CharSequence)":", null, null, (int)0, null, Key::toKeyString$lambda$0, (int)30, null);
    }

    @Override
    public int compareTo(@NotNull Key other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return COMPARATOR.compare(this, other);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<Variant> component2() {
        return this.variants;
    }

    @NotNull
    public final Key copy(@NotNull String name, @NotNull List<Variant> variants) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        return new Key(name, variants);
    }

    public static /* synthetic */ Key copy$default(Key key, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = key.name;
        }
        if ((n & 2) != 0) {
            list = key.variants;
        }
        return key.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "Key(name=" + this.name + ", variants=" + this.variants + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.variants).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Key)) {
            return false;
        }
        Key key = (Key)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)key.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.variants, key.variants);
    }

    private static final CharSequence toKeyString$lambda$0(Variant it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toKeyString();
    }

    private static final int COMPARATOR$lambda$2(Key o1, Key o2) {
        int n = Math.min(o1.variants.size(), o2.variants.size());
        for (int i = 0; i < n; ++i) {
            int result = o1.variants.get(i).compareTo(o2.variants.get(i));
            if (result == 0) continue;
            return result;
        }
        return Intrinsics.compare((int)o1.variants.size(), (int)o2.variants.size());
    }

    private static final int COMPARATOR$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rR7\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lbase/boudicca/model/structured/Key$Companion;", "", "<init>", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lbase/boudicca/model/structured/Key;", "kotlin.jvm.PlatformType", "getCOMPARATOR", "()Ljava/util/Comparator;", "Ljava/util/Comparator;", "parse", "keyFilter", "", "builder", "Lbase/boudicca/model/structured/Key$KeyBuilder;", "propertyName", "common-model"})
    public static final class Companion {
        private Companion() {
        }

        public final Comparator<Key> getCOMPARATOR() {
            return COMPARATOR;
        }

        @NotNull
        public final Key parse(@NotNull String keyFilter) {
            Intrinsics.checkNotNullParameter((Object)keyFilter, (String)"keyFilter");
            return KeyUtils.INSTANCE.parseKey(keyFilter);
        }

        @NotNull
        public final KeyBuilder builder(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            return new KeyBuilder(propertyName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbase/boudicca/model/structured/Key$KeyBuilder;", "", "propertyName", "", "<init>", "(Ljava/lang/String;)V", "variants", "", "Lbase/boudicca/model/structured/Variant;", "withVariant", "variantName", "variantValue", "variant", "withVariants", "newVariants", "", "build", "Lbase/boudicca/model/structured/Key;", "common-model"})
    public static final class KeyBuilder {
        @NotNull
        private final String propertyName;
        @NotNull
        private final List<Variant> variants;

        public KeyBuilder(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.propertyName = propertyName;
            this.variants = new ArrayList();
        }

        @NotNull
        public final KeyBuilder withVariant(@NotNull String variantName, @NotNull String variantValue) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)variantValue, (String)"variantValue");
            return this.withVariant(new Variant(variantName, variantValue));
        }

        @NotNull
        public final KeyBuilder withVariant(@NotNull Variant variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this.variants.add(variant);
            return this;
        }

        @NotNull
        public final KeyBuilder withVariants(@NotNull List<Variant> newVariants) {
            Intrinsics.checkNotNullParameter(newVariants, (String)"newVariants");
            this.variants.addAll((Collection<Variant>)newVariants);
            return this;
        }

        @NotNull
        public final Key build() {
            return new Key(this.propertyName, CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)this.variants)));
        }
    }
}

