/*
 * Decompiled with CFR 0.152.
 */
package base.boudicca.model.structured;

import base.boudicca.Property;
import base.boudicca.format.DateFormat;
import base.boudicca.keyfilters.KeyFilters;
import base.boudicca.keyfilters.KeySelector;
import base.boudicca.model.Event;
import base.boudicca.model.structured.AbstractStructuredBuilder;
import base.boudicca.model.structured.Key;
import base.boudicca.model.structured.KeyUtils;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 02\u00020\u0001:\u000201B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0006\u0010\u0014\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007j\u0002`\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J,\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u001a\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eJ6\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u001a\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J \u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u001b0\u001a2\u0006\u0010!\u001a\u00020\bJ \u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u001b0#2\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J3\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lbase/boudicca/model/structured/StructuredEvent;", "", "name", "", "startDate", "Ljava/time/OffsetDateTime;", "data", "", "Lbase/boudicca/model/structured/Key;", "<init>", "(Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/util/Map;)V", "event", "Lbase/boudicca/model/Event;", "(Lbase/boudicca/model/Event;)V", "getName", "()Ljava/lang/String;", "getStartDate", "()Ljava/time/OffsetDateTime;", "getData", "()Ljava/util/Map;", "toFlatEvent", "toEntry", "Lbase/boudicca/model/structured/StructuredEntry;", "toBuilder", "Lbase/boudicca/model/structured/StructuredEvent$StructuredEventBuilder;", "getProperty", "", "Lkotlin/Pair;", "T", "property", "Lbase/boudicca/Property;", "language", "filterKeys", "keyFilter", "selectKey", "Ljava/util/Optional;", "keySelector", "Lbase/boudicca/keyfilters/KeySelector;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "StructuredEventBuilder", "common-model"})
@SourceDebugExtension(value={"SMAP\nStructuredEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructuredEvent.kt\nbase/boudicca/model/structured/StructuredEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1611#2,9:148\n1863#2:157\n1864#2:159\n1620#2:160\n1#3:158\n*S KotlinDebug\n*F\n+ 1 StructuredEvent.kt\nbase/boudicca/model/structured/StructuredEvent\n*L\n43#1:148,9\n43#1:157\n43#1:159\n43#1:160\n43#1:158\n*E\n"})
public final class StructuredEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final OffsetDateTime startDate;
    @NotNull
    private final Map<Key, String> data;

    public StructuredEvent(@NotNull String name, @NotNull OffsetDateTime startDate, @NotNull Map<Key, String> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.name = name;
        this.startDate = startDate;
        this.data = data;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @NotNull
    public final Map<Key, String> getData() {
        return this.data;
    }

    public StructuredEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this(event.getName(), event.getStartDate(), KeyUtils.INSTANCE.toStructuredKeyValuePairs(event.getData()));
    }

    @NotNull
    public final Event toFlatEvent() {
        return new Event(this.name, this.startDate, KeyUtils.INSTANCE.toFlatKeyValuePairs(this.data));
    }

    @NotNull
    public final Map<Key, String> toEntry() {
        return Companion.toEntry(this);
    }

    @NotNull
    public final StructuredEventBuilder toBuilder() {
        return new StructuredEventBuilder(this.name, this.startDate, this.data);
    }

    @NotNull
    public final <T> List<Pair<Key, T>> getProperty(@NotNull Property<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.getProperty(property, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<Pair<Key, T>> getProperty(@NotNull Property<T> property, @Nullable String language) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Iterable $this$mapNotNull$iv = KeyFilters.INSTANCE.filterKeys(property.getKey(language), this);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            try {
                T parsedValue = property.parseFromString((String)it.getSecond());
                pair = new Pair(it.getFirst(), parsedValue);
            }
            catch (IllegalArgumentException e) {
                pair = null;
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Pair<Key, String>> filterKeys(@NotNull Key keyFilter) {
        Intrinsics.checkNotNullParameter((Object)keyFilter, (String)"keyFilter");
        return KeyFilters.INSTANCE.filterKeys(keyFilter, this);
    }

    @NotNull
    public final Optional<Pair<Key, String>> selectKey(@NotNull KeySelector keySelector) {
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        return keySelector.selectSingle(this);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final OffsetDateTime component2() {
        return this.startDate;
    }

    @NotNull
    public final Map<Key, String> component3() {
        return this.data;
    }

    @NotNull
    public final StructuredEvent copy(@NotNull String name, @NotNull OffsetDateTime startDate, @NotNull Map<Key, String> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return new StructuredEvent(name, startDate, data);
    }

    public static /* synthetic */ StructuredEvent copy$default(StructuredEvent structuredEvent, String string, OffsetDateTime offsetDateTime, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = structuredEvent.name;
        }
        if ((n & 2) != 0) {
            offsetDateTime = structuredEvent.startDate;
        }
        if ((n & 4) != 0) {
            map = structuredEvent.data;
        }
        return structuredEvent.copy(string, offsetDateTime, map);
    }

    @NotNull
    public String toString() {
        return "StructuredEvent(name=" + this.name + ", startDate=" + this.startDate + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.startDate.hashCode();
        result = result * 31 + ((Object)this.data).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructuredEvent)) {
            return false;
        }
        StructuredEvent structuredEvent = (StructuredEvent)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)structuredEvent.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)structuredEvent.startDate)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, structuredEvent.data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lbase/boudicca/model/structured/StructuredEvent$Companion;", "", "<init>", "()V", "toEntry", "", "Lbase/boudicca/model/structured/Key;", "", "Lbase/boudicca/model/structured/StructuredEntry;", "event", "Lbase/boudicca/model/structured/StructuredEvent;", "fromEntry", "Ljava/util/Optional;", "entry", "builder", "Lbase/boudicca/model/structured/StructuredEvent$StructuredEventBuilder;", "name", "startDate", "Ljava/time/OffsetDateTime;", "common-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Key, String> toEntry(@NotNull StructuredEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Map entry = MapsKt.toMutableMap(event.getData());
            entry.put(Key.Companion.builder("name").build(), event.getName());
            entry.put(Key.Companion.builder("startDate").withVariant("format", "date").build(), DateFormat.INSTANCE.parseToString(event.getStartDate()));
            return entry;
        }

        @NotNull
        public final Optional<StructuredEvent> fromEntry(@NotNull Map<Key, String> entry) {
            OffsetDateTime offsetDateTime;
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            Object[] objectArray = new String[]{"date", ""};
            Optional<Pair<Key, String>> startDatePair = KeySelector.Companion.builder("startDate").thenVariant("format", CollectionsKt.listOf((Object[])objectArray)).build().selectSingle(entry);
            Optional<Pair<Key, String>> namePair = KeySelector.Companion.builder("name").build().selectSingle(entry);
            if (namePair.isEmpty() || startDatePair.isEmpty()) {
                Optional<StructuredEvent> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            String name = (String)namePair.get().getSecond();
            try {
                offsetDateTime = DateFormat.INSTANCE.parseFromString((String)startDatePair.get().getSecond());
            }
            catch (IllegalArgumentException e) {
                Optional<StructuredEvent> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            OffsetDateTime startDate = offsetDateTime;
            Map data = MapsKt.toMutableMap(entry);
            data.remove(namePair.get().getFirst());
            data.remove(startDatePair.get().getFirst());
            Optional<StructuredEvent> optional = Optional.of(new StructuredEvent(name, startDate, data));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return optional;
        }

        @NotNull
        public final StructuredEventBuilder builder() {
            return new StructuredEventBuilder(null, null, null, 4, null);
        }

        @NotNull
        public final StructuredEventBuilder builder(@NotNull String name, @NotNull OffsetDateTime startDate) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            return new StructuredEventBuilder(name, startDate, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0000J\b\u0010\u000f\u001a\u00020\u0002H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lbase/boudicca/model/structured/StructuredEvent$StructuredEventBuilder;", "Lbase/boudicca/model/structured/AbstractStructuredBuilder;", "Lbase/boudicca/model/structured/StructuredEvent;", "name", "", "startDate", "Ljava/time/OffsetDateTime;", "data", "", "Lbase/boudicca/model/structured/Key;", "<init>", "(Ljava/lang/String;Ljava/time/OffsetDateTime;Ljava/util/Map;)V", "withName", "withStartDate", "copy", "build", "common-model"})
    public static final class StructuredEventBuilder
    extends AbstractStructuredBuilder<StructuredEvent, StructuredEventBuilder> {
        @Nullable
        private String name;
        @Nullable
        private OffsetDateTime startDate;

        public StructuredEventBuilder(@Nullable String name, @Nullable OffsetDateTime startDate, @NotNull Map<Key, String> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            super(MapsKt.toMutableMap(data));
            this.name = name;
            this.startDate = startDate;
        }

        public /* synthetic */ StructuredEventBuilder(String string, OffsetDateTime offsetDateTime, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, offsetDateTime, map);
        }

        @NotNull
        public final StructuredEventBuilder withName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        @NotNull
        public final StructuredEventBuilder withStartDate(@NotNull OffsetDateTime startDate) {
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        @NotNull
        public final StructuredEventBuilder copy() {
            return new StructuredEventBuilder(this.name, this.startDate, MapsKt.toMutableMap(this.getData()));
        }

        @Override
        @NotNull
        public StructuredEvent build() {
            if (this.name == null) {
                throw new IllegalStateException("name cannot be null for an event!");
            }
            if (this.startDate == null) {
                throw new IllegalStateException("startDate cannot be null for an event!");
            }
            String string = this.name;
            Intrinsics.checkNotNull((Object)string);
            OffsetDateTime offsetDateTime = this.startDate;
            Intrinsics.checkNotNull((Object)offsetDateTime);
            return new StructuredEvent(string, offsetDateTime, MapsKt.toMap(this.getData()));
        }
    }
}

