/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.server.UID;
import java.util.HashMap;
import org.apache.excalibur.altrmi.client.AltrmiClientInvocationHandler;
import org.apache.excalibur.altrmi.client.AltrmiFactory;
import org.apache.excalibur.altrmi.client.AltrmiHostContext;
import org.apache.excalibur.altrmi.client.AltrmiProxy;
import org.apache.excalibur.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.excalibur.altrmi.client.impl.AbstractHostContext;
import org.apache.excalibur.altrmi.client.impl.AbstractSameVmBindableHostContext;
import org.apache.excalibur.altrmi.client.impl.DefaultProxyHelper;
import org.apache.excalibur.altrmi.common.AltrmiAuthentication;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.ExceptionReply;
import org.apache.excalibur.altrmi.common.FacadeRefHolder;
import org.apache.excalibur.altrmi.common.ListReply;
import org.apache.excalibur.altrmi.common.ListRequest;
import org.apache.excalibur.altrmi.common.LookupReply;
import org.apache.excalibur.altrmi.common.LookupRequest;
import org.apache.excalibur.altrmi.common.NotPublishedReply;
import org.apache.excalibur.altrmi.common.OpenConnectionReply;
import org.apache.excalibur.altrmi.common.OpenConnectionRequest;
import org.apache.excalibur.altrmi.common.SameVMReply;

public abstract class AbstractAltrmiFactory
implements AltrmiFactory {
    private static final UID U_ID = new UID(20729);
    protected AbstractHostContext m_hostContext;
    protected AltrmiClientInvocationHandler m_clientInvocationHandler;
    protected final HashMap m_refObjs = new HashMap();
    private final boolean m_beanOnly;
    private transient String m_textToSign;
    protected Long m_session;

    public AbstractAltrmiFactory(boolean beanOnly) {
        this.m_beanOnly = beanOnly;
    }

    public final boolean isBeanOnly() {
        return this.m_beanOnly;
    }

    public void setHostContext(AltrmiHostContext hostContext) throws IOException {
        this.setHostContext(hostContext, true);
    }

    public void setHostContext(AltrmiHostContext hostContext, boolean allowOptimize) throws IOException {
        AltrmiReply reply;
        UID machineID;
        if (this.m_hostContext == null) {
            this.m_hostContext = (AbstractHostContext)hostContext;
            this.m_clientInvocationHandler = this.m_hostContext.getClientInvocationHandler();
        }
        ((AbstractClientInvocationHandler)this.m_clientInvocationHandler).initialize();
        UID uID = machineID = allowOptimize ? U_ID : null;
        if (!(this.m_hostContext instanceof AbstractSameVmBindableHostContext)) {
            machineID = null;
        }
        if ((reply = this.m_clientInvocationHandler.handleInvocation((AltrmiRequest)new OpenConnectionRequest(machineID))) instanceof SameVMReply) {
            if (this.m_hostContext instanceof AbstractSameVmBindableHostContext) {
                AbstractSameVmBindableHostContext sameVmBindableHostContext = (AbstractSameVmBindableHostContext)this.m_hostContext;
                AbstractHostContext hContext = sameVmBindableHostContext.makeSameVmHostContext();
                if (hContext == null) {
                    reply = this.m_clientInvocationHandler.handleInvocation((AltrmiRequest)new OpenConnectionRequest(null));
                } else {
                    this.m_clientInvocationHandler = this.m_hostContext.getClientInvocationHandler();
                    reply = this.m_clientInvocationHandler.handleInvocation((AltrmiRequest)new OpenConnectionRequest());
                }
            } else {
                throw new IOException("SameVM instruction for non rebindable host context.");
            }
        }
        if (!(reply instanceof OpenConnectionReply)) {
            throw new IOException("Setting of host context blocked for reasons of unknown, server-side reply: (" + reply.getClass().getName() + ")");
        }
        this.m_textToSign = ((OpenConnectionReply)reply).getTextToSign();
        this.m_session = ((OpenConnectionReply)reply).getSession();
    }

    public Object lookup(String publishedServiceName, AltrmiAuthentication altrmiAuthentication) throws AltrmiConnectionException {
        AltrmiReply ar = this.m_clientInvocationHandler.handleInvocation((AltrmiRequest)new LookupRequest(publishedServiceName, altrmiAuthentication, this.m_session));
        if (ar.getReplyCode() >= 100) {
            if (ar instanceof NotPublishedReply) {
                throw new AltrmiConnectionException("Service " + publishedServiceName + " not published");
            }
            if (ar instanceof ExceptionReply) {
                ExceptionReply er = (ExceptionReply)ar;
                throw (AltrmiConnectionException)er.getReplyException();
            }
            throw new AltrmiConnectionException("Problem doing lookup on service");
        }
        if (ar instanceof ExceptionReply) {
            ExceptionReply er = (ExceptionReply)ar;
            Throwable t = er.getReplyException();
            if (t instanceof AltrmiConnectionException) {
                throw (AltrmiConnectionException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new AltrmiConnectionException("Problem doing lookup on service [exception: " + t.getMessage() + "]");
        }
        if (!(ar instanceof LookupReply)) {
            throw new UnsupportedOperationException("Unexpected reply to lookup [reply: " + ar + "]");
        }
        LookupReply lr = (LookupReply)ar;
        DefaultProxyHelper baseObj = new DefaultProxyHelper(this, this.m_clientInvocationHandler, publishedServiceName, "Main", lr.getReferenceID(), this.m_session);
        Object retVal = this.getInstance(publishedServiceName, "Main", baseObj, this.isBeanOnly());
        baseObj.registerImplObject(retVal);
        return retVal;
    }

    protected abstract Class getFacadeClass(String var1, String var2, boolean var3) throws AltrmiConnectionException, ClassNotFoundException;

    protected abstract Object getInstance(String var1, String var2, DefaultProxyHelper var3, boolean var4) throws AltrmiConnectionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerReferenceObject(Object obj, Long referenceID) {
        AbstractAltrmiFactory abstractAltrmiFactory = this;
        synchronized (abstractAltrmiFactory) {
            this.m_refObjs.put(referenceID, new WeakReference<Object>(obj));
        }
    }

    public final Long getReferenceID(AltrmiProxy obj) {
        return obj.altrmiGetReferenceID((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getImplObj(Long referenceID) {
        WeakReference wr = null;
        AbstractAltrmiFactory abstractAltrmiFactory = this;
        synchronized (abstractAltrmiFactory) {
            wr = (WeakReference)this.m_refObjs.get(referenceID);
        }
        if (wr == null) {
            return null;
        }
        Object obj = wr.get();
        if (obj == null) {
            this.m_refObjs.remove(referenceID);
        }
        return obj;
    }

    public final Object lookup(String publishedServiceName) throws AltrmiConnectionException {
        return this.lookup(publishedServiceName, null);
    }

    public String getTextToSignForAuthentication() {
        return this.m_textToSign;
    }

    public String[] list() {
        AltrmiReply ar = this.m_clientInvocationHandler.handleInvocation((AltrmiRequest)new ListRequest());
        if (ar instanceof ListReply) {
            return ((ListReply)ar).getListOfPublishedObjects();
        }
        return new String[0];
    }

    private FacadeRefHolder makeFacadeRefHolder(AltrmiProxy obj, String objectName) {
        Long refID = this.getReferenceID(obj);
        return new FacadeRefHolder(refID, objectName);
    }

    public void marshallCorrection(String methodSignature, Object[] args, Class[] argClasses) {
        int i = 0;
        while (i < args.length) {
            Class argClass = argClasses[i];
            if (argClass != null) {
                if (args[i] instanceof AltrmiProxy) {
                    AltrmiProxy proxy = (AltrmiProxy)args[i];
                    if (this.getReferenceID(proxy) != null) {
                        String objName = args[i].getClass().getName().substring(16);
                        args[i] = this.makeFacadeRefHolder(proxy, objName);
                    }
                } else {
                    args[i] = this.m_clientInvocationHandler.resolveArgument(methodSignature, argClasses[i], args[i]);
                }
            }
            ++i;
        }
    }
}

