/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import org.apache.excalibur.altrmi.client.AltrmiClientInvocationHandler;
import org.apache.excalibur.altrmi.client.AltrmiConnectionPinger;
import org.apache.excalibur.altrmi.common.AltrmiConnectionClosedException;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;

public abstract class AbstractConnectionPinger
implements AltrmiConnectionPinger {
    private AltrmiClientInvocationHandler m_altrmiInvocationHandler;
    private boolean m_continue = true;
    private Runnable m_runnable;
    private Thread m_thread;
    private final long m_pingInterval;
    private final long m_giveupInterval;

    public AbstractConnectionPinger(int pingIntervalSeconds, int giveupIntervalSeconds) {
        this.m_pingInterval = pingIntervalSeconds * 1000;
        this.m_giveupInterval = giveupIntervalSeconds * 1000;
    }

    public AbstractConnectionPinger(long pingIntervalMilliSeconds, long giveupIntervalMilliSeconds) {
        this.m_pingInterval = pingIntervalMilliSeconds;
        this.m_giveupInterval = giveupIntervalMilliSeconds;
    }

    public AbstractConnectionPinger() {
        this.m_pingInterval = 10000L;
        this.m_giveupInterval = 100000L;
    }

    public void setAltrmiInvocationHandler(AltrmiClientInvocationHandler altrmiInvocationHandler) {
        this.m_altrmiInvocationHandler = altrmiInvocationHandler;
    }

    protected AltrmiClientInvocationHandler getAltrmiInvocationHandler() {
        return this.m_altrmiInvocationHandler;
    }

    public void start() {
        this.m_runnable = new Runnable(){

            public void run() {
                block5: {
                    try {
                        while (AbstractConnectionPinger.this.m_continue) {
                            Thread.sleep(AbstractConnectionPinger.this.m_pingInterval);
                            AbstractConnectionPinger.this.ping();
                        }
                    }
                    catch (AltrmiInvocationException ie) {
                    }
                    catch (AltrmiConnectionClosedException cce) {
                    }
                    catch (InterruptedException e) {
                        if (!AbstractConnectionPinger.this.m_continue) break block5;
                        System.err.println("Unexpected interuption of pnger thread - " + e.getMessage());
                    }
                }
            }
        };
        this.m_thread = new Thread(this.m_runnable, "AltrmiConnectionPinger Thread");
        this.m_thread.start();
    }

    public void stop() {
        this.m_continue = false;
        this.m_thread.interrupt();
        this.m_thread = null;
    }

    protected abstract void ping();

    public long getGiveupInterval() {
        return this.m_giveupInterval;
    }
}

