/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import java.util.Vector;
import org.apache.excalibur.altrmi.client.AltrmiInterfaceLookup;
import org.apache.excalibur.altrmi.client.AltrmiInterfaceLookupFactory;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;

public class AbstractInterfaceLookupFactory
implements AltrmiInterfaceLookupFactory {
    private Vector factories = new Vector();

    protected void addFactory(String factoryStringPrefix, AltrmiInterfaceLookupFactory factory) {
        this.factories.add(new Factory(factoryStringPrefix, factory));
    }

    public final AltrmiInterfaceLookup getAltrmiInterfaceLookup(String factoryString, boolean optimize) throws AltrmiConnectionException {
        return this.getAltrmiInterfaceLookup(factoryString, this.getClass().getClassLoader(), optimize);
    }

    public AltrmiInterfaceLookup getAltrmiInterfaceLookup(String factoryString, ClassLoader interfacesClassLoader, boolean optimize) throws AltrmiConnectionException {
        int i = 0;
        while (i < this.factories.size()) {
            Factory factory = (Factory)this.factories.elementAt(i);
            if (factoryString.startsWith(factory.factoryStringPrefix)) {
                return factory.altrmiInterfaceLookupFactory.getAltrmiInterfaceLookup(factoryString, interfacesClassLoader, optimize);
            }
            ++i;
        }
        return null;
    }

    private class Factory {
        private String factoryStringPrefix;
        private AltrmiInterfaceLookupFactory altrmiInterfaceLookupFactory;

        public Factory(String factoryStringPrefix, AltrmiInterfaceLookupFactory altrmiInterfaceLookupFactory) {
            this.factoryStringPrefix = factoryStringPrefix;
            this.altrmiInterfaceLookupFactory = altrmiInterfaceLookupFactory;
        }
    }
}

