/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.excalibur.altrmi.client.impl.AbstractAltrmiFactory;
import org.apache.excalibur.altrmi.client.impl.DefaultProxyHelper;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;

public class ClientClassAltrmiFactory
extends AbstractAltrmiFactory {
    public ClientClassAltrmiFactory(boolean beanOnly) {
        super(beanOnly);
    }

    protected Class getFacadeClass(String publishedServiceName, String objectName, boolean beanOnly) throws AltrmiConnectionException, ClassNotFoundException {
        String code = "2";
        if (beanOnly) {
            code = "";
        }
        String className = "AltrmiGenerated" + code + publishedServiceName + "_" + objectName;
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    protected Object getInstance(String publishedServiceName, String objectName, DefaultProxyHelper proxyHelper, boolean beanOnly) throws AltrmiConnectionException {
        try {
            Class clazz = this.getFacadeClass(publishedServiceName, objectName, beanOnly);
            Constructor<?>[] constructors = clazz.getConstructors();
            Object retVal = constructors[0].newInstance(proxyHelper);
            return retVal;
        }
        catch (InvocationTargetException ite) {
            throw new AltrmiConnectionException("Generated class not instantiated : " + ite.getTargetException().getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new AltrmiConnectionException("Generated class not found during lookup : " + cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new AltrmiConnectionException("Generated class not instantiable during lookup : " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new AltrmiConnectionException("Illegal access to generated class during lookup : " + iae.getMessage());
        }
    }

    public void close() {
        this.m_hostContext.getClientInvocationHandler().close();
    }
}

