/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.client.impl;

import org.apache.excalibur.altrmi.client.AltrmiConnectionListener;
import org.apache.excalibur.altrmi.common.AltrmiInvocationException;
import org.apache.excalibur.altrmi.common.AltrmiRequest;

public class DefaultConnectionListener
implements AltrmiConnectionListener {
    private int m_maxReconnectAttempts;

    public DefaultConnectionListener() {
        this(3);
    }

    public DefaultConnectionListener(int maxReconnectAttempts) {
        this.m_maxReconnectAttempts = maxReconnectAttempts;
    }

    public void methodCalled(String methodSignature, long duration) {
    }

    public boolean methodLogging() {
        return true;
    }

    public void serviceSuspended(AltrmiRequest altrmiRequest, int attempt, int suggestedWaitMillis) {
        if (attempt == 10) {
            throw new AltrmiInvocationException("Too many retries on suspended service");
        }
        System.out.println("AltRMI service suspended, Trying to reconnect (attempt " + attempt + ", waiting for " + suggestedWaitMillis / 1000 + " seconds)");
        try {
            Thread.sleep(suggestedWaitMillis);
        }
        catch (InterruptedException ie) {
            System.out.println("InterruptedException in Listener " + ie.getMessage());
        }
    }

    public void serviceAbend(int attempt) {
        if (attempt >= this.m_maxReconnectAttempts) {
            String msg = this.m_maxReconnectAttempts <= 0 ? "Reconnect to abended service disabled." : "Too many retries on abended service";
            throw new AltrmiInvocationException(msg);
        }
        System.out.println("AltRMI service abnormally ended, Trying to reconnect (attempt " + attempt + ")");
        try {
            Thread.sleep((2 ^ attempt) * 500);
        }
        catch (InterruptedException ie) {
            System.out.println("InterruptedException in Listener " + ie.getMessage());
        }
    }
}

